/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.tls;

import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.SRP6GroupParameters;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSRPIdentityManager;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import com.aspose.cad.internal.bouncycastle.crypto.tls.TlsUtils;
import com.aspose.cad.internal.bouncycastle.util.Strings;
import java.math.BigInteger;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] a = Strings.toByteArray("password");
    private static final byte[] b = Strings.toByteArray("salt");
    protected SRP6GroupParameters group;
    protected SRP6VerifierGenerator verifierGenerator;
    protected Mac mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(SRP6GroupParameters sRP6GroupParameters, byte[] byArray) {
        SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(sRP6GroupParameters, TlsUtils.createHash((short)2));
        HMac hMac = new HMac(TlsUtils.createHash((short)2));
        hMac.init(new KeyParameter(byArray));
        return new SimulatedTlsSRPIdentityManager(sRP6GroupParameters, sRP6VerifierGenerator, hMac);
    }

    public SimulatedTlsSRPIdentityManager(SRP6GroupParameters sRP6GroupParameters, SRP6VerifierGenerator sRP6VerifierGenerator, Mac mac) {
        this.group = sRP6GroupParameters;
        this.verifierGenerator = sRP6VerifierGenerator;
        this.mac = mac;
    }

    @Override
    public TlsSRPLoginParameters getLoginParameters(byte[] byArray) {
        this.mac.update(b, 0, b.length);
        this.mac.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray2, 0);
        this.mac.update(a, 0, a.length);
        this.mac.update(byArray, 0, byArray.length);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        BigInteger bigInteger = this.verifierGenerator.generateVerifier(byArray2, byArray, byArray3);
        return new TlsSRPLoginParameters(this.group, bigInteger, byArray2);
    }
}

