/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.signers;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.CryptoException;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.Signer;
import com.aspose.cad.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher a;
    private final Digest b;
    private boolean c;

    public GenericSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this.a = asymmetricBlockCipher;
        this.b = digest;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.c = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.a.init(bl2, cipherParameters);
    }

    @Override
    public void update(byte by2) {
        this.b.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.b.update(byArray, n2, n3);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.c) {
            throw new IllegalStateException("GenericSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        return this.a.processBlock(byArray, 0, byArray.length);
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        if (this.c) {
            throw new IllegalStateException("GenericSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray2, 0);
        try {
            byte[] byArray3 = this.a.processBlock(byArray, 0, byArray.length);
            if (byArray3.length < byArray2.length) {
                byte[] byArray4 = new byte[byArray2.length];
                System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
                byArray3 = byArray4;
            }
            return Arrays.constantTimeAreEqual(byArray3, byArray2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void reset() {
        this.b.reset();
    }
}

