/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.modes;

import com.aspose.cad.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.BufferedBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.cad.internal.bouncycastle.util.Pack;

public class KXTSBlockCipher
extends BufferedBlockCipher {
    private static final long a = 135L;
    private static final long b = 1061L;
    private static final long c = 293L;
    private final int d;
    private final long e;
    private final long[] f;
    private final long[] g;
    private int h;

    protected static long getReductionPolynomial(int n2) {
        switch (n2) {
            case 16: {
                return 135L;
            }
            case 32: {
                return 1061L;
            }
            case 64: {
                return 293L;
            }
        }
        throw new IllegalArgumentException("Only 128, 256, and 512 -bit block sizes supported");
    }

    public KXTSBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.d = blockCipher.getBlockSize();
        this.e = KXTSBlockCipher.getReductionPolynomial(this.d);
        this.f = new long[this.d >>> 3];
        this.g = new long[this.d >>> 3];
        this.h = -1;
    }

    @Override
    public int getOutputSize(int n2) {
        return n2;
    }

    @Override
    public int getUpdateOutputSize(int n2) {
        return n2;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("Invalid parameters passed");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        cipherParameters = parametersWithIV.getParameters();
        byte[] byArray = parametersWithIV.getIV();
        if (byArray.length != this.d) {
            throw new IllegalArgumentException("Currently only support IVs of exactly one block");
        }
        byte[] byArray2 = new byte[this.d];
        System.arraycopy(byArray, 0, byArray2, 0, this.d);
        this.cipher.init(true, cipherParameters);
        this.cipher.processBlock(byArray2, 0, byArray2, 0);
        this.cipher.init(bl2, cipherParameters);
        Pack.littleEndianToLong(byArray2, 0, this.f);
        System.arraycopy(this.f, 0, this.g, 0, this.f.length);
        this.h = 0;
    }

    @Override
    public int processByte(byte by2, byte[] byArray, int n2) {
        throw new IllegalStateException("unsupported operation");
    }

    @Override
    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (byArray.length - n2 < n3) {
            throw new DataLengthException("Input buffer too short");
        }
        if (byArray2.length - n2 < n3) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (n3 % this.d != 0) {
            throw new IllegalArgumentException("Partial blocks not supported");
        }
        for (int i2 = 0; i2 < n3; i2 += this.d) {
            this.a(byArray, n2 + i2, byArray2, n4 + i2);
        }
        return n3;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        if (this.h == -1) {
            throw new IllegalStateException("Attempt to process too many blocks");
        }
        ++this.h;
        KXTSBlockCipher.a(this.e, this.g);
        byte[] byArray3 = new byte[this.d];
        Pack.longToLittleEndian(this.g, byArray3, 0);
        byte[] byArray4 = new byte[this.d];
        System.arraycopy(byArray3, 0, byArray4, 0, this.d);
        for (n4 = 0; n4 < this.d; ++n4) {
            int n5 = n4;
            byArray4[n5] = (byte)(byArray4[n5] ^ byArray[n2 + n4]);
        }
        this.cipher.processBlock(byArray4, 0, byArray4, 0);
        for (n4 = 0; n4 < this.d; ++n4) {
            byArray2[n3 + n4] = (byte)(byArray4[n4] ^ byArray3[n4]);
        }
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.reset();
        return 0;
    }

    @Override
    public void reset() {
        this.cipher.reset();
        System.arraycopy(this.f, 0, this.g, 0, this.f.length);
        this.h = 0;
    }

    private static void a(long l2, long[] lArray) {
        long l3 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l4 = lArray[i2];
            long l5 = l4 >>> 63;
            lArray[i2] = l4 << 1 ^ l3;
            l3 = l5;
        }
        lArray[0] = lArray[0] ^ l2 & -l3;
    }
}

