/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.kems;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.cad.internal.bouncycastle.crypto.KeyEncapsulation;
import com.aspose.cad.internal.bouncycastle.crypto.params.KDFParameters;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.cad.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger a = BigInteger.valueOf(0L);
    private static final BigInteger b = BigInteger.valueOf(1L);
    private DerivationFunction c;
    private SecureRandom d;
    private RSAKeyParameters e;

    public RSAKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.c = derivationFunction;
        this.d = secureRandom;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("RSA key required");
        }
        this.e = (RSAKeyParameters)cipherParameters;
    }

    @Override
    public CipherParameters encrypt(byte[] byArray, int n2, int n3) throws IllegalArgumentException {
        if (this.e.isPrivate()) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger bigInteger = this.e.getModulus();
        BigInteger bigInteger2 = this.e.getExponent();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(a, bigInteger.subtract(b), this.d);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        byte[] byArray2 = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger4);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return this.generateKey(bigInteger, bigInteger3, n3);
    }

    public CipherParameters encrypt(byte[] byArray, int n2) {
        return this.encrypt(byArray, 0, n2);
    }

    @Override
    public CipherParameters decrypt(byte[] byArray, int n2, int n3, int n4) throws IllegalArgumentException {
        if (!this.e.isPrivate()) {
            throw new IllegalArgumentException("Private key required for decryption");
        }
        BigInteger bigInteger = this.e.getModulus();
        BigInteger bigInteger2 = this.e.getExponent();
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return this.generateKey(bigInteger, bigInteger4, n4);
    }

    public CipherParameters decrypt(byte[] byArray, int n2) {
        return this.decrypt(byArray, 0, byArray.length, n2);
    }

    protected KeyParameter generateKey(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((bigInteger.bitLength() + 7) / 8, bigInteger2);
        this.c.init(new KDFParameters(byArray, null));
        byte[] byArray2 = new byte[n2];
        this.c.generateBytes(byArray2, 0, byArray2.length);
        return new KeyParameter(byArray2);
    }
}

