/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.encodings;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.cad.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.cad.internal.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

public class ISO9796d1Encoding
implements AsymmetricBlockCipher {
    private static final BigInteger a = BigInteger.valueOf(16L);
    private static final BigInteger b = BigInteger.valueOf(6L);
    private static byte[] c = new byte[]{14, 3, 5, 8, 9, 4, 2, 15, 0, 13, 11, 6, 7, 10, 12, 1};
    private static byte[] d = new byte[]{8, 15, 6, 1, 5, 2, 11, 12, 3, 4, 13, 10, 14, 9, 0, 7};
    private AsymmetricBlockCipher e;
    private boolean f;
    private int g;
    private int h = 0;
    private BigInteger i;

    public ISO9796d1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.e = asymmetricBlockCipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.e;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = null;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithRandom.getParameters();
        } else {
            rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        }
        this.e.init(bl2, cipherParameters);
        this.i = rSAKeyParameters.getModulus();
        this.g = this.i.bitLength();
        this.f = bl2;
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.e.getInputBlockSize();
        if (this.f) {
            return (n2 + 1) / 2;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.e.getOutputBlockSize();
        if (this.f) {
            return n2;
        }
        return (n2 + 1) / 2;
    }

    public void setPadBits(int n2) {
        if (n2 > 7) {
            throw new IllegalArgumentException("padBits > 7");
        }
        this.h = n2;
    }

    public int getPadBits() {
        return this.h;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.f) {
            return this.a(byArray, n2, n3);
        }
        return this.b(byArray, n2, n3);
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte by2;
        int n4;
        byte[] byArray2 = new byte[(this.g + 7) / 8];
        int n5 = this.h + 1;
        int n6 = n3;
        int n7 = (this.g + 13) / 16;
        for (n4 = 0; n4 < n7; n4 += n6) {
            if (n4 > n7 - n6) {
                System.arraycopy(byArray, n2 + n3 - (n7 - n4), byArray2, byArray2.length - n7, n7 - n4);
                continue;
            }
            System.arraycopy(byArray, n2, byArray2, byArray2.length - (n4 + n6), n6);
        }
        for (n4 = byArray2.length - 2 * n7; n4 != byArray2.length; n4 += 2) {
            by2 = byArray2[byArray2.length - n7 + n4 / 2];
            byArray2[n4] = (byte)(c[(by2 & 0xFF) >>> 4] << 4 | c[by2 & 0xF]);
            byArray2[n4 + 1] = by2;
        }
        int n8 = byArray2.length - 2 * n6;
        byArray2[n8] = (byte)(byArray2[n8] ^ n5);
        byArray2[byArray2.length - 1] = (byte)(byArray2[byArray2.length - 1] << 4 | 6);
        n4 = 8 - (this.g - 1) % 8;
        by2 = 0;
        if (n4 != 8) {
            byArray2[0] = (byte)(byArray2[0] & 255 >>> n4);
            byArray2[0] = (byte)(byArray2[0] | 128 >>> n4);
        } else {
            byArray2[0] = 0;
            byArray2[1] = (byte)(byArray2[1] | 0x80);
            by2 = 1;
        }
        return this.e.processBlock(byArray2, by2, byArray2.length - by2);
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        BigInteger bigInteger;
        byte[] byArray2 = this.e.processBlock(byArray, n2, n3);
        int n5 = 1;
        int n6 = (this.g + 13) / 16;
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        if (bigInteger2.mod(a).equals(b)) {
            bigInteger = bigInteger2;
        } else if (this.i.subtract(bigInteger2).mod(a).equals(b)) {
            bigInteger = this.i.subtract(bigInteger2);
        } else {
            throw new InvalidCipherTextException("resulting integer iS or (modulus - iS) is not congruent to 6 mod 16");
        }
        byArray2 = ISO9796d1Encoding.a(bigInteger);
        if ((byArray2[byArray2.length - 1] & 0xF) != 6) {
            throw new InvalidCipherTextException("invalid forcing byte in block");
        }
        byArray2[byArray2.length - 1] = (byte)((byArray2[byArray2.length - 1] & 0xFF) >>> 4 | d[(byArray2[byArray2.length - 2] & 0xFF) >> 4] << 4);
        byArray2[0] = (byte)(c[(byArray2[1] & 0xFF) >>> 4] << 4 | c[byArray2[1] & 0xF]);
        boolean bl2 = false;
        int n7 = 0;
        for (int i2 = byArray2.length - 1; i2 >= byArray2.length - 2 * n6; i2 -= 2) {
            n4 = c[(byArray2[i2] & 0xFF) >>> 4] << 4 | c[byArray2[i2] & 0xF];
            if (((byArray2[i2 - 1] ^ n4) & 0xFF) == 0) continue;
            if (!bl2) {
                bl2 = true;
                n5 = (byArray2[i2 - 1] ^ n4) & 0xFF;
                n7 = i2 - 1;
                continue;
            }
            throw new InvalidCipherTextException("invalid tsums in block");
        }
        byArray2[n7] = 0;
        byte[] byArray3 = new byte[(byArray2.length - n7) / 2];
        for (n4 = 0; n4 < byArray3.length; ++n4) {
            byArray3[n4] = byArray2[2 * n4 + n7 + 1];
        }
        this.h = n5 - 1;
        return byArray3;
    }

    private static byte[] a(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }
}

