/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto;

import com.aspose.cad.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.InvalidCipherTextException;

public class BufferedAsymmetricBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    private final AsymmetricBlockCipher a;

    public BufferedAsymmetricBlockCipher(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.a = asymmetricBlockCipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.a;
    }

    public int getBufferPosition() {
        return this.bufOff;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.reset();
        this.a.init(bl2, cipherParameters);
        this.buf = new byte[this.a.getInputBlockSize() + (bl2 ? 1 : 0)];
        this.bufOff = 0;
    }

    public int getInputBlockSize() {
        return this.a.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.a.getOutputBlockSize();
    }

    public void processByte(byte by2) {
        if (this.bufOff >= this.buf.length) {
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        this.buf[this.bufOff++] = by2;
    }

    public void processBytes(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        if (this.bufOff + n3 > this.buf.length) {
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public byte[] doFinal() throws InvalidCipherTextException {
        byte[] byArray = this.a.processBlock(this.buf, 0, this.bufOff);
        this.reset();
        return byArray;
    }

    public void reset() {
        if (this.buf != null) {
            for (int i2 = 0; i2 < this.buf.length; ++i2) {
                this.buf[i2] = 0;
            }
        }
        this.bufOff = 0;
    }
}

