/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.DigestedData;
import com.aspose.cad.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.cad.internal.bouncycastle.cms.CMSException;
import com.aspose.cad.internal.bouncycastle.cms.CMSProcessable;
import com.aspose.cad.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.cad.internal.bouncycastle.cms.o;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculator;
import com.aspose.cad.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.cad.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.cad.internal.bouncycastle.util.Arrays;
import com.aspose.cad.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMSDigestedData
implements Encodable {
    private ContentInfo a;
    private DigestedData b;

    public CMSDigestedData(byte[] byArray) throws CMSException {
        this(o.a(byArray));
    }

    public CMSDigestedData(InputStream inputStream) throws CMSException {
        this(o.a(inputStream));
    }

    public CMSDigestedData(ContentInfo contentInfo) throws CMSException {
        this.a = contentInfo;
        try {
            this.b = DigestedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.a.getContentType();
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.b.getDigestAlgorithm();
    }

    public CMSProcessable getDigestedContent() throws CMSException {
        ContentInfo contentInfo = this.b.getEncapContentInfo();
        try {
            return new CMSProcessableByteArray(contentInfo.getContentType(), ((ASN1OctetString)contentInfo.getContent()).getOctets());
        }
        catch (Exception exception) {
            throw new CMSException("exception reading digested stream.", exception);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.a;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.a.getEncoded();
    }

    public boolean verify(DigestCalculatorProvider digestCalculatorProvider) throws CMSException {
        try {
            ContentInfo contentInfo = this.b.getEncapContentInfo();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(this.b.getDigestAlgorithm());
            OutputStream outputStream = digestCalculator.getOutputStream();
            outputStream.write(((ASN1OctetString)contentInfo.getContent()).getOctets());
            return Arrays.areEqual(this.b.getDigest(), digestCalculator.getDigest());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("unable to create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        catch (IOException iOException) {
            throw new CMSException("unable process content: " + iOException.getMessage(), iOException);
        }
    }
}

