/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cryptopro;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class GostR3410TransportParameters
extends ASN1Object {
    private final ASN1ObjectIdentifier a;
    private final SubjectPublicKeyInfo b;
    private final byte[] c;

    public GostR3410TransportParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo, byte[] byArray) {
        this.a = aSN1ObjectIdentifier;
        this.b = subjectPublicKeyInfo;
        this.c = Arrays.clone(byArray);
    }

    private GostR3410TransportParameters(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            this.a = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.c = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets();
            this.b = null;
        } else if (aSN1Sequence.size() == 3) {
            this.a = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.b = SubjectPublicKeyInfo.getInstance(ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(1)), false);
            this.c = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets();
        } else {
            throw new IllegalArgumentException("unknown sequence length: " + aSN1Sequence.size());
        }
    }

    public static GostR3410TransportParameters getInstance(Object object) {
        if (object instanceof GostR3410TransportParameters) {
            return (GostR3410TransportParameters)object;
        }
        if (object != null) {
            return new GostR3410TransportParameters(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static GostR3410TransportParameters getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return new GostR3410TransportParameters(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.a;
    }

    public SubjectPublicKeyInfo getEphemeralPublicKey() {
        return this.b;
    }

    public byte[] getUkm() {
        return Arrays.clone(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        aSN1EncodableVector.add(new DEROctetString(this.c));
        return new DERSequence(aSN1EncodableVector);
    }
}

