/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cms;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.BERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.BERSet;
import com.aspose.cad.internal.bouncycastle.asn1.BERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.aspose.cad.internal.bouncycastle.asn1.cms.ContentInfo;
import com.aspose.cad.internal.bouncycastle.asn1.cms.SignerInfo;
import java.util.Enumeration;

public class SignedData
extends ASN1Object {
    private static final ASN1Integer a = new ASN1Integer(1L);
    private static final ASN1Integer b = new ASN1Integer(3L);
    private static final ASN1Integer c = new ASN1Integer(4L);
    private static final ASN1Integer d = new ASN1Integer(5L);
    private ASN1Integer e;
    private ASN1Set f;
    private ContentInfo g;
    private ASN1Set h;
    private ASN1Set i;
    private ASN1Set j;
    private boolean k;
    private boolean l;

    public static SignedData getInstance(Object object) {
        if (object instanceof SignedData) {
            return (SignedData)object;
        }
        if (object != null) {
            return new SignedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public SignedData(ASN1Set aSN1Set, ContentInfo contentInfo, ASN1Set aSN1Set2, ASN1Set aSN1Set3, ASN1Set aSN1Set4) {
        this.e = this.a(contentInfo.getContentType(), aSN1Set2, aSN1Set3, aSN1Set4);
        this.f = aSN1Set;
        this.g = contentInfo;
        this.h = aSN1Set2;
        this.i = aSN1Set3;
        this.j = aSN1Set4;
        this.l = aSN1Set3 instanceof BERSet;
        this.k = aSN1Set2 instanceof BERSet;
    }

    private ASN1Integer a(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Set aSN1Set, ASN1Set aSN1Set2, ASN1Set aSN1Set3) {
        Object e2;
        Enumeration enumeration;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (aSN1Set != null) {
            enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (!(e2 instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(e2);
                if (aSN1TaggedObject.getTagNo() == 1) {
                    bl4 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() == 2) {
                    bl5 = true;
                    continue;
                }
                if (aSN1TaggedObject.getTagNo() != 3) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            return new ASN1Integer(5L);
        }
        if (aSN1Set2 != null) {
            enumeration = aSN1Set2.getObjects();
            while (enumeration.hasMoreElements()) {
                e2 = enumeration.nextElement();
                if (!(e2 instanceof ASN1TaggedObject)) continue;
                bl3 = true;
            }
        }
        if (bl3) {
            return d;
        }
        if (bl5) {
            return c;
        }
        if (bl4) {
            return b;
        }
        if (this.a(aSN1Set3)) {
            return b;
        }
        if (!CMSObjectIdentifiers.data.equals(aSN1ObjectIdentifier)) {
            return b;
        }
        return a;
    }

    private boolean a(ASN1Set aSN1Set) {
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = SignerInfo.getInstance(enumeration.nextElement());
            if (signerInfo.getVersion().getValue().intValue() != 3) continue;
            return true;
        }
        return false;
    }

    private SignedData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.e = ASN1Integer.getInstance(enumeration.nextElement());
        this.f = (ASN1Set)enumeration.nextElement();
        this.g = ContentInfo.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1Primitive aSN1Primitive = (ASN1Primitive)enumeration.nextElement();
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.k = aSN1TaggedObject instanceof BERTaggedObject;
                        this.h = ASN1Set.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    case 1: {
                        this.l = aSN1TaggedObject instanceof BERTaggedObject;
                        this.i = ASN1Set.getInstance(aSN1TaggedObject, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag value " + aSN1TaggedObject.getTagNo());
                    }
                }
                continue;
            }
            this.j = (ASN1Set)aSN1Primitive;
        }
    }

    public ASN1Integer getVersion() {
        return this.e;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.f;
    }

    public ContentInfo getEncapContentInfo() {
        return this.g;
    }

    public ASN1Set getCertificates() {
        return this.h;
    }

    public ASN1Set getCRLs() {
        return this.i;
    }

    public ASN1Set getSignerInfos() {
        return this.j;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        aSN1EncodableVector.add(this.g);
        if (this.h != null) {
            if (this.k) {
                aSN1EncodableVector.add(new BERTaggedObject(false, 0, this.h));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.h));
            }
        }
        if (this.i != null) {
            if (this.l) {
                aSN1EncodableVector.add(new BERTaggedObject(false, 1, this.i));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.i));
            }
        }
        aSN1EncodableVector.add(this.j);
        return new BERSequence(aSN1EncodableVector);
    }
}

