/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.x509.GeneralName;
import java.math.BigInteger;

public class GetCert
extends ASN1Object {
    private final GeneralName a;
    private final BigInteger b;

    private GetCert(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = GeneralName.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue();
    }

    public GetCert(GeneralName generalName, BigInteger bigInteger) {
        this.a = generalName;
        this.b = bigInteger;
    }

    public static GetCert getInstance(Object object) {
        if (object instanceof GetCert) {
            return (GetCert)object;
        }
        if (object != null) {
            return new GetCert(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public GeneralName getIssuerName() {
        return this.a;
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

