/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.BodyPartPath;

public class CMCUnsignedData
extends ASN1Object {
    private final BodyPartPath a;
    private final ASN1ObjectIdentifier b;
    private final ASN1Encodable c;

    public CMCUnsignedData(BodyPartPath bodyPartPath, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.a = bodyPartPath;
        this.b = aSN1ObjectIdentifier;
        this.c = aSN1Encodable;
    }

    private CMCUnsignedData(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 3) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.a = BodyPartPath.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1ObjectIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = aSN1Sequence.getObjectAt(2);
    }

    public static CMCUnsignedData getInstance(Object object) {
        if (object instanceof CMCUnsignedData) {
            return (CMCUnsignedData)object;
        }
        if (object != null) {
            return new CMCUnsignedData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    public BodyPartPath getBodyPartPath() {
        return this.a;
    }

    public ASN1ObjectIdentifier getIdentifier() {
        return this.b;
    }

    public ASN1Encodable getContent() {
        return this.c;
    }
}

