/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.asn1.cmc;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.BodyPartID;
import com.aspose.cad.internal.bouncycastle.asn1.cmc.BodyPartPath;
import java.io.IOException;

public class BodyPartReference
extends ASN1Object
implements ASN1Choice {
    private final BodyPartID a;
    private final BodyPartPath b;

    public BodyPartReference(BodyPartID bodyPartID) {
        this.a = bodyPartID;
        this.b = null;
    }

    public BodyPartReference(BodyPartPath bodyPartPath) {
        this.a = null;
        this.b = bodyPartPath;
    }

    public static BodyPartReference getInstance(Object object) {
        if (object instanceof BodyPartReference) {
            return (BodyPartReference)object;
        }
        if (object != null) {
            if (object instanceof ASN1Encodable) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
                if (aSN1Primitive instanceof ASN1Integer) {
                    return new BodyPartReference(BodyPartID.getInstance(aSN1Primitive));
                }
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return new BodyPartReference(BodyPartPath.getInstance(aSN1Primitive));
                }
            }
            if (object instanceof byte[]) {
                try {
                    return BodyPartReference.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("unknown encoding in getInstance()");
                }
            }
            throw new IllegalArgumentException("unknown object in getInstance(): " + object.getClass().getName());
        }
        return null;
    }

    public boolean isBodyPartID() {
        return this.a != null;
    }

    public BodyPartID getBodyPartID() {
        return this.a;
    }

    public BodyPartPath getBodyPartPath() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        return this.b.toASN1Primitive();
    }
}

