/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.tiff.filemanagement;

import com.aspose.cad.StreamContainer;
import com.aspose.cad.fileformats.tiff.TiffRational;
import com.aspose.cad.fileformats.tiff.TiffSRational;
import com.aspose.cad.internal.Exceptions.ArgumentNullException;
import com.aspose.cad.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.aw;
import com.aspose.cad.internal.N.bE;
import com.aspose.cad.internal.aC.m;
import com.aspose.cad.internal.eU.bs;
import com.aspose.cad.internal.uE.a;
import com.aspose.cad.internal.uG.d;
import com.aspose.cad.system.io.MemoryStream;
import com.aspose.cad.system.io.Stream;

public class TiffStreamReader {
    private StreamContainer a;
    private final byte[] b;
    private int c;
    private final long d;
    private boolean e = true;

    public TiffStreamReader(byte[] byArray) {
        this(byArray, 0, byArray != null ? byArray.length : 0);
    }

    public TiffStreamReader(byte[] byArray, int n2) {
        this(byArray, n2, byArray != null ? byArray.length : 0);
    }

    public TiffStreamReader(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new ArgumentNullException("data");
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "The start index should be positive number.");
        }
        if (n2 >= byArray.length && n3 > 0) {
            throw new ArgumentOutOfRangeException("startIndex", "The start index should be less than the byte array data length.");
        }
        if (n3 < 0) {
            throw new ArgumentOutOfRangeException("dataLength", "The data length should be positive number.");
        }
        if (n2 + n3 > byArray.length) {
            throw new ArgumentOutOfRangeException("dataLength", "The data length is out of byte array bounds.");
        }
        this.b = byArray;
        this.c = n2;
        this.d = n3;
    }

    public TiffStreamReader(StreamContainer streamContainer) {
        this.a = streamContainer;
        this.b = null;
        this.d = streamContainer.getLength();
    }

    public long getLength() {
        return this.d;
    }

    public boolean getThrowExceptions() {
        return this.e;
    }

    public void setThrowExceptions(boolean bl2) {
        this.e = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readBytes(byte[] byArray, int n2, long l2, long l3) {
        if (byArray == null) {
            throw new ArgumentNullException("array");
        }
        long l4 = byArray.length;
        if (l3 + (long)n2 > l4) {
            throw new ArgumentOutOfRangeException("count", "The number of bytes to retrieve exceeds the array bounds.");
        }
        if (l2 < 0L) {
            throw new ArgumentOutOfRangeException("position", "Incorrect position specified. Must be positive number.");
        }
        long l5 = l2 + (long)this.c;
        long l6 = l2 + l3;
        long l7 = bE.a(0L, l3 - bE.a(0L, l6 - this.d));
        if (this.b != null) {
            System.arraycopy(this.b, (int)l5, byArray, n2, (int)l7);
        } else {
            Object object = this.a.getSyncRoot();
            synchronized (object) {
                long l8 = this.a.getPosition();
                this.a.seek(l2, 0);
                if ((long)this.a.read(byArray, n2, (int)l7) != l7) {
                    throw new ArgumentOutOfRangeException("count", aX.a(new String[]{"Cannot read ", aw.b(l7), " bytes from stream."}));
                }
                this.a.setPosition(l8);
            }
        }
        return l7;
    }

    public byte[] readBytes(long l2, long l3) {
        byte[] byArray = new byte[(int)l3];
        this.readBytes(byArray, 0, l2, l3);
        return byArray;
    }

    public double readDouble(long l2) {
        double[] dArray = this.readDoubleArray(l2, 1L);
        double d2 = 0.0;
        if (dArray != null && dArray.length == 1) {
            d2 = dArray[0];
        }
        return d2;
    }

    public double[] readDoubleArray(long l2, long l3) {
        double[] dArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x8=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                dArray = this.processReadDataDouble(byArray);
            }
        }
        return dArray;
    }

    public float readFloat(long l2) {
        float[] fArray = this.readFloatArray(l2, 1L);
        float f2 = 0.0f;
        if (fArray != null && fArray.length == 1) {
            f2 = fArray[0];
        }
        return f2;
    }

    public float[] readFloatArray(long l2, long l3) {
        float[] fArray = null;
        long l4 = l3 * 4L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x4=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                fArray = this.processReadDataFloat(byArray);
            }
        }
        return fArray;
    }

    public TiffRational readRational(long l2) {
        TiffRational[] tiffRationalArray = this.readRationalArray(l2, 1L);
        TiffRational tiffRational = null;
        if (tiffRationalArray != null && tiffRationalArray.length == 1) {
            tiffRational = tiffRationalArray[0];
        }
        return tiffRational;
    }

    public TiffSRational readSRational(long l2) {
        TiffSRational[] tiffSRationalArray = this.readSRationalArray(l2, 1L);
        TiffSRational tiffSRational = null;
        if (tiffSRationalArray != null && tiffSRationalArray.length == 1) {
            tiffSRational = tiffSRationalArray[0];
        }
        return tiffSRational;
    }

    public TiffRational[] readRationalArray(long l2, long l3) {
        TiffRational[] tiffRationalArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x8=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                long[] lArray = this.processReadDataULong(byArray);
                tiffRationalArray = new TiffRational[(int)l3];
                int n2 = 0;
                while ((long)n2 < l3) {
                    tiffRationalArray[n2] = new TiffRational(lArray[n2 * 2], lArray[n2 * 2 + 1]);
                    ++n2;
                }
            }
        }
        return tiffRationalArray;
    }

    public TiffSRational[] readSRationalArray(long l2, long l3) {
        TiffSRational[] tiffSRationalArray = null;
        long l4 = l3 * 8L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x8=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                int[] nArray = this.processReadDataLong(byArray);
                tiffSRationalArray = new TiffSRational[(int)l3];
                int n2 = 0;
                while ((long)n2 < l3) {
                    tiffSRationalArray[n2] = new TiffSRational(nArray[n2 * 2], nArray[n2 * 2 + 1]);
                    ++n2;
                }
            }
        }
        return tiffSRationalArray;
    }

    public byte readSByte(long l2) {
        byte[] byArray = this.readSByteArray(l2, 1L);
        byte by2 = 0;
        if (byArray != null && byArray.length == 1) {
            by2 = byArray[0];
        }
        return by2;
    }

    public byte[] readSByteArray(long l2, long l3) {
        byte[] byArray = this.readBytes(l2, l3);
        return byArray;
    }

    public int readSLong(long l2) {
        int[] nArray = this.readSLongArray(l2, 1L);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] readSLongArray(long l2, long l3) {
        int[] nArray = null;
        long l4 = l3 * 4L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x4=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                nArray = this.processReadDataLong(byArray);
            }
        }
        return nArray;
    }

    public short readSShort(long l2) {
        short[] sArray = this.readSShortArray(l2, 1L);
        short s2 = 0;
        if (sArray != null && sArray.length == 1) {
            s2 = sArray[0];
        }
        return s2;
    }

    public short[] readSShortArray(long l2, long l3) {
        short[] sArray = null;
        long l4 = l3 * 2L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x2=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                sArray = this.processReadDataShort(byArray);
            }
        }
        return sArray;
    }

    public long readULong(long l2) {
        long[] lArray = this.readULongArray(l2, 1L);
        long l3 = 0L;
        if (lArray != null && lArray.length == 1) {
            l3 = lArray[0];
        }
        return l3;
    }

    public long[] readULongArray(long l2, long l3) {
        long[] lArray = null;
        long l4 = l3 * 4L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x4=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                lArray = this.processReadDataULong(byArray);
            }
        }
        return lArray;
    }

    public int readUShort(long l2) {
        int[] nArray = this.readUShortArray(l2, 1L);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] readUShortArray(long l2, long l3) {
        int[] nArray = null;
        long l4 = l3 * 2L;
        if (l4 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aX.a("Total bytes count is negative. ", aw.b(l3), "x2=", aw.b(l4)));
            }
        } else {
            byte[] byArray = this.readBytes(l2, l4);
            if (byArray != null) {
                nArray = this.processReadDataUShort(byArray);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamContainer toStreamContainer(long l2) {
        StreamContainer streamContainer;
        Stream stream = this.a == null ? null : this.a.a();
        Object object = bs.a(stream);
        synchronized (object) {
            if (this.b != null) {
                int n2 = (int)(this.d - l2);
                MemoryStream memoryStream = new MemoryStream(this.b, this.c + (int)l2, n2);
                streamContainer = new StreamContainer(memoryStream, true);
            } else {
                this.a.seek(l2, 0);
                Stream stream2 = this.a.a();
                streamContainer = new StreamContainer(stream2.toInputStream());
            }
        }
        return streamContainer;
    }

    public final String a(long l2, long l3) {
        byte[] byArray = this.readBytes(l2, l3);
        return m.t().c(byArray);
    }

    public final String a(long l2) {
        return this.a(l2, (long)this.b.length - l2);
    }

    protected double[] processReadDataDouble(byte[] byArray) {
        return com.aspose.cad.internal.uG.d.a.h(byArray);
    }

    protected float[] processReadDataFloat(byte[] byArray) {
        return com.aspose.cad.internal.uG.d.a.g(byArray);
    }

    protected int[] processReadDataLong(byte[] byArray) {
        return com.aspose.cad.internal.uG.d.a.c(byArray);
    }

    protected short[] processReadDataShort(byte[] byArray) {
        return com.aspose.cad.internal.uG.d.a.a(byArray);
    }

    protected long[] processReadDataULong(byte[] byArray) {
        if (byArray.length == 0) {
            return com.aspose.cad.internal.uE.a.d;
        }
        return com.aspose.cad.internal.uG.d.a.e(byArray);
    }

    protected int[] processReadDataUShort(byte[] byArray) {
        if (byArray.length == 0) {
            return com.aspose.cad.internal.uE.a.c;
        }
        return com.aspose.cad.internal.uG.d.a.b(byArray);
    }
}

