/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.StructuredDataRecord;
import com.aspose.cad.fileformats.cgm.commands.ColourIndexPrecision;
import com.aspose.cad.fileformats.cgm.commands.ColourPrecision;
import com.aspose.cad.fileformats.cgm.commands.ColourSelectionMode;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.TileElement;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.fileformats.cgm.enums.CompressionType;
import com.aspose.cad.system.io.MemoryStream;

public class Tile
extends TileElement {
    private int a;

    public final int getCellColorPrecision() {
        return this.a;
    }

    public final void setCellColorPrecision(int n2) {
        this.a = n2;
    }

    public Tile(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 29, cgmFile));
    }

    public Tile(CgmFile cgmFile, CompressionType compressionType, int n2, int n3, StructuredDataRecord structuredDataRecord, byte[] byArray) {
        this(cgmFile, compressionType, n2, n3, structuredDataRecord, new MemoryStream(byArray));
    }

    Tile(CgmFile cgmFile, CompressionType compressionType, int n2, int n3, StructuredDataRecord structuredDataRecord, MemoryStream memoryStream) {
        this(cgmFile);
        this.setCompressionType(compressionType);
        this.setRowPaddingIndicator(n2);
        this.setDataRecord(structuredDataRecord);
        this.a(memoryStream);
        this.setCellColorPrecision(n3);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setCompressionType(CompressionType.values()[iBinaryReader.readIndex()]);
        this.setRowPaddingIndicator(iBinaryReader.readInt());
        this.setCellColorPrecision(iBinaryReader.readInt());
        if (this.getCellColorPrecision() == 0) {
            // empty if block
        }
        this.readSdrAndBitStream(iBinaryReader);
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getCompressionType().ordinal());
        iBinaryWriter.writeInt(this.getRowPaddingIndicator());
        iBinaryWriter.writeInt(this.getCellColorPrecision());
        this.writeSdrAndBitStream(iBinaryWriter);
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(" TILE");
        iClearTextWriter.write(String.format(" %s", this.writeInt(this.getCompressionType().ordinal())));
        iClearTextWriter.write(String.format(" %s", this.writeInt(this.getRowPaddingIndicator())));
        if (this.getCellColorPrecision() == 0) {
            if (this._container.getColourSelectionMode() == ColourSelectionMode.Type.INDEXED) {
                iClearTextWriter.write(ColourIndexPrecision.writeValue(this._container.getColourIndexPrecision()));
            } else {
                iClearTextWriter.write(ColourPrecision.writeValue(this._container.getColourPrecision()));
            }
        } else {
            iClearTextWriter.write(this.writeInt(this.getCellColorPrecision()));
        }
        this.writeSDR(iClearTextWriter, this.getDataRecord());
        if (this.a() != null) {
            iClearTextWriter.write(String.format(" %s", this.writeBitStream(this.a().toArray())));
        }
        iClearTextWriter.writeLine(";");
    }

    @Override
    protected void readBitmap(IBinaryReader iBinaryReader) {
        iBinaryReader.unsupported("BITMAP for Tile");
    }

    @Override
    protected void writeBitmap(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.unsupported("BITMAP for Tile");
    }

    @Override
    public String toString() {
        return String.format("Tile [compressionType=%d, rowPaddingIndicator=%d]", new Object[]{this.getCompressionType(), this.getRowPaddingIndicator()});
    }
}

