/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class SymbolSize
extends Command {
    private ScaleIndicator a;
    private double b;
    private double c;

    public final ScaleIndicator getIndicator() {
        return this.a;
    }

    public final void setIndicator(ScaleIndicator scaleIndicator) {
        this.a = scaleIndicator;
    }

    public final double getHeight() {
        return this.b;
    }

    public final void setHeight(double d2) {
        this.b = d2;
    }

    public final double getWidth() {
        return this.c;
    }

    public final void setWidth(double d2) {
        this.c = d2;
    }

    public SymbolSize(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 50, cgmFile));
    }

    public SymbolSize(CgmFile cgmFile, ScaleIndicator scaleIndicator, double d2, double d3) {
        this(cgmFile);
        this.setIndicator(scaleIndicator);
        this.setWidth(d2);
        this.setHeight(d3);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setIndicator(ScaleIndicator.values()[iBinaryReader.readEnum()]);
        this.setHeight(iBinaryReader.readVdc());
        this.setWidth(iBinaryReader.readVdc());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getIndicator().ordinal());
        iBinaryWriter.writeVdc(this.getHeight());
        iBinaryWriter.writeVdc(this.getWidth());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" SYMBOLSIZE %s %s %s;", SymbolSize.a(this.getIndicator().toString()), this.writeVDC(this.getHeight()), this.writeVDC(this.getWidth())));
    }

    public static enum ScaleIndicator {
        HEIGHT,
        WIDTH,
        BOTH;

    }
}

