/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.TextCommand;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;

public class RestrictedText
extends TextCommand {
    private double a;
    private double b;
    private boolean c;

    public final double getDeltaWidth() {
        return this.a;
    }

    public final void setDeltaWidth(double d2) {
        this.a = d2;
    }

    public final double getDeltaHeight() {
        return this.b;
    }

    public final void setDeltaHeight(double d2) {
        this.b = d2;
    }

    public final boolean getFinal() {
        return this.c;
    }

    public final void setFinal(boolean bl2) {
        this.c = bl2;
    }

    public RestrictedText(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 5, cgmFile));
    }

    public RestrictedText(CgmFile cgmFile, String string, CgmPoint cgmPoint, double d2, double d3, boolean bl2) {
        this(cgmFile);
        this.setDeltaWidth(d2);
        this.setDeltaHeight(d3);
        this.setFinal(bl2);
        this.setValues(string, cgmPoint);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setDeltaWidth(iBinaryReader.readVdc());
        this.setDeltaHeight(iBinaryReader.readVdc());
        this.setPosition(iBinaryReader.readPoint());
        this.setFinal(iBinaryReader.readBool());
        this.setText(iBinaryReader.readString());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeVdc(this.getDeltaWidth());
        iBinaryWriter.writeVdc(this.getDeltaHeight());
        iBinaryWriter.writePoint(this.getPosition());
        iBinaryWriter.writeBool(this.getFinal());
        iBinaryWriter.writeString(this.getText());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  RESTRTEXT");
        iClearTextWriter.write(aX.a(new String[]{" ", RestrictedText.writeDouble(this.getDeltaWidth())}));
        iClearTextWriter.write(aX.a(new String[]{" ", RestrictedText.writeDouble(this.getDeltaHeight())}));
        iClearTextWriter.write(aX.a(new String[]{"  ", this.writePoint(this.getPosition())}));
        if (this.getFinal()) {
            iClearTextWriter.write(" final");
        } else {
            iClearTextWriter.write(" notfinal");
        }
        iClearTextWriter.write(String.format(" %s", this.writeString(this.getText())));
        iClearTextWriter.writeLine(";");
    }

    @Override
    public String toString() {
        return String.format("RestrictedText %s deltaWidth=%s deltaHeight=%s textPosition.x=%s textPosition.y=%s", this.getText(), RestrictedText.writeDouble(this.getDeltaWidth()), RestrictedText.writeDouble(this.getDeltaHeight()), RestrictedText.writeDouble(this.getPosition().getX()), RestrictedText.writeDouble(this.getPosition().getY()));
    }
}

