/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.j;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.g;
import com.aspose.cad.internal.tM.d;

public class PolygonElement
extends Command {
    private CgmPoint[] a;

    public final CgmPoint[] getPoints() {
        return this.a;
    }

    public final void setPoints(CgmPoint[] cgmPointArray) {
        this.a = cgmPointArray;
    }

    public PolygonElement(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 7, cgmFile));
    }

    public PolygonElement(CgmFile cgmFile, CgmPoint[] cgmPointArray) {
        this(cgmFile);
        this.setPoints(cgmPointArray);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        PolygonElement.assert_((iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg()) % iBinaryReader.sizeOfPoint() == 0, "Invalid amount of arguments");
        int n2 = (iBinaryReader.getArguments().length - iBinaryReader.getCurrentArg()) / iBinaryReader.sizeOfPoint();
        this.setPoints(new CgmPoint[n2]);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getPoints()[i2] = iBinaryReader.readPoint();
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        for (CgmPoint cgmPoint : this.getPoints()) {
            iBinaryWriter.writePoint(cgmPoint);
        }
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  POLYGON");
        for (CgmPoint cgmPoint : this.getPoints()) {
            iClearTextWriter.write(String.format(" %s", this.writePoint(cgmPoint)));
        }
        iClearTextWriter.writeLine(";");
    }

    @Override
    public String toString() {
        return "PolygonElement " + aX.a(", ", new d<CgmPoint>(CgmPoint.class, g.a(this.getPoints())).a(new j(this), String.class).i());
    }
}

