/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class MessageCommand
extends Command {
    private ActionType a;
    private String b;

    public final ActionType getAction() {
        return this.a;
    }

    public final void setAction(ActionType actionType) {
        this.a = actionType;
    }

    public final String getMessage() {
        return this.b;
    }

    public final void setMessage(String string) {
        this.b = string;
    }

    public MessageCommand(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.ExternalElements, 1, cgmFile));
    }

    public MessageCommand(CgmFile cgmFile, ActionType actionType, String string) {
        this(cgmFile);
        this.setAction(actionType);
        this.setMessage(string);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setAction(ActionType.values()[iBinaryReader.readEnum()]);
        this.setMessage(iBinaryReader.readString());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getAction().ordinal());
        iBinaryWriter.writeString(this.getMessage());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" MESSAGE %s, %s;", MessageCommand.a(this.getAction().toString()), this.writeString(this.getMessage())));
    }

    public static enum ActionType {
        NoAction,
        Action;

    }
}

