/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class InheritanceFilter
extends Command {
    private Filter[] a;
    private int b;

    public final Filter[] getValues() {
        return this.a;
    }

    public final void setValues(Filter[] filterArray) {
        this.a = filterArray;
    }

    public final int getSetting() {
        return this.b;
    }

    public final void setSetting(int n2) {
        this.b = n2;
    }

    public InheritanceFilter(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.SegmentControlandSegmentAttributeElements, 2, cgmFile));
    }

    public InheritanceFilter(CgmFile cgmFile, Filter[] filterArray, int n2) {
        this(cgmFile);
        this.setValues(filterArray);
        this.setSetting(n2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = (iBinaryReader.getArguments().length - 1) / iBinaryReader.sizeOfEnum();
        this.setValues(new Filter[n2]);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getValues()[i2] = Filter.values()[iBinaryReader.readEnum()];
        }
        this.setSetting(iBinaryReader.readEnum());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        for (Filter filter : this.getValues()) {
            iBinaryWriter.writeEnum(filter.ordinal());
        }
        iBinaryWriter.writeEnum(this.getSetting());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  INHFILTER");
        for (Filter filter : this.getValues()) {
            iClearTextWriter.write(String.format(" %s", InheritanceFilter.a(filter.toString())));
        }
        if (this.getSetting() == 0) {
            iClearTextWriter.write(" stlist");
        } else {
            iClearTextWriter.write(" seg");
        }
        iClearTextWriter.writeLine(";");
    }

    public static enum Filter {
        LINEINDEX,
        LINETYPE,
        LINEWIDTH,
        LINECOLR,
        LINECLIPMODE,
        MARKERINDEX,
        MARKERTYPE,
        MARKERSIZE,
        MARKERCOLR,
        MARKERCLIPMODE,
        TEXTINDEX,
        TEXTFONTINDEX,
        TEXTPREC,
        CHAREXPAN,
        CHARSPACE,
        TEXTCOLR,
        CHARHEIGHT,
        CHARORI,
        TEXTPATH,
        TEXTALIGN,
        FILLINDEX,
        INTSTYLE,
        FILLCOLR,
        HATCHINDEX,
        PATINDEX,
        EDGEINDEX,
        EDGETYPE,
        EDGEWIDTH,
        EDGECOLR,
        EDGEVIS,
        EDGECLIPMODE,
        FILLREFPT,
        PATSIZE,
        AUXCOLR,
        TRANSPARENCY,
        LINEATTR,
        MARKERATTR,
        TEXPRESANDPLACEMATTR,
        TEXTPLACEMANDORIATTR,
        FILLATTR,
        EDGEATTR,
        PATATTR,
        OUTPUTCTRL,
        PICKID,
        ALLATTRCTRL,
        ALLINH,
        LINETYPEASF,
        LINEWIDTHASF,
        LINECOLRASF,
        MARKERTYPEASF,
        MARKERSIZEASF,
        MARKERCOLRASF,
        TEXTFONTINDEXASF,
        TEXTPRECASF,
        CHAREXPANASF,
        CHARSPACEASF,
        TEXTCOLRASF,
        INTSTYLEASF,
        FILLCOLRASF,
        HATCHINDEXASF,
        PATINDEXASF,
        EDGETYPEASF,
        EDGEWIDTHASF,
        EDGECOLRASF,
        ALLLINE,
        ALLMARKER,
        ALLTEXT,
        ALLFILL,
        ALLEDGE,
        ALL,
        MITRELIMIT,
        LINECAP,
        LINEJOIN,
        LINETYPECONT,
        LINETYPEINITOFFSET,
        TEXTSCORETYPE,
        RESTRTEXTTYPE,
        INTERPOLATEDINTERIOR,
        EDGECAP,
        EDGEJOIN,
        EDGETYPECONT,
        EDGETYPEINITOFFSET,
        SYMBOLLIBINDEX,
        SYMBOLCOLR,
        SYMBOLSIZE,
        SYMBOLORI,
        SYMBOLATTR;

    }
}

