/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class HyperbolicArc
extends Command {
    private CgmPoint a;
    private CgmPoint b;
    private CgmPoint c;
    private double d;
    private double e;
    private double f;
    private double g;

    public final CgmPoint getCenter() {
        return this.a;
    }

    public final void setCenter(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final CgmPoint getTransverseRadius() {
        return this.b;
    }

    public final void setTransverseRadius(CgmPoint cgmPoint) {
        this.b = cgmPoint;
    }

    public final CgmPoint getConjugateRadius() {
        return this.c;
    }

    public final void setConjugateRadius(CgmPoint cgmPoint) {
        this.c = cgmPoint;
    }

    public final double getStartX() {
        return this.d;
    }

    public final void setStartX(double d2) {
        this.d = d2;
    }

    public final double getStartY() {
        return this.e;
    }

    public final void setStartY(double d2) {
        this.e = d2;
    }

    public final double getEndX() {
        return this.f;
    }

    public final void setEndX(double d2) {
        this.f = d2;
    }

    public final double getEndY() {
        return this.g;
    }

    public final void setEndY(double d2) {
        this.g = d2;
    }

    public HyperbolicArc(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 22, cgmFile));
    }

    public HyperbolicArc(CgmFile cgmFile, CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3, double d2, double d3, double d4, double d5) {
        this(cgmFile);
        this.setCenter(cgmPoint);
        this.setTransverseRadius(cgmPoint2);
        this.setConjugateRadius(cgmPoint3);
        this.setStartX(d2);
        this.setStartY(d3);
        this.setEndX(d4);
        this.setEndY(d5);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setCenter(iBinaryReader.readPoint());
        this.setTransverseRadius(iBinaryReader.readPoint());
        this.setConjugateRadius(iBinaryReader.readPoint());
        this.setStartX(iBinaryReader.readVdc());
        this.setStartY(iBinaryReader.readVdc());
        this.setEndX(iBinaryReader.readVdc());
        this.setEndY(iBinaryReader.readVdc());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getCenter());
        iBinaryWriter.writePoint(this.getTransverseRadius());
        iBinaryWriter.writePoint(this.getConjugateRadius());
        iBinaryWriter.writeVdc(this.getStartX());
        iBinaryWriter.writeVdc(this.getStartY());
        iBinaryWriter.writeVdc(this.getEndX());
        iBinaryWriter.writeVdc(this.getEndY());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" HYPERBARC %s %s %s %s %s %s %s;", this.writePoint(this.getCenter()), this.writePoint(this.getTransverseRadius()), this.writePoint(this.getConjugateRadius()), this.writeVDC(this.getStartX()), this.writeVDC(this.getStartY()), this.writeVDC(this.getEndX()), this.writeVDC(this.getEndY())));
    }
}

