/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.EllipticalArc;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.fileformats.cgm.enums.ClosureType;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class EllipticalArcClose
extends EllipticalArc {
    private ClosureType a;

    public final ClosureType getClosureType() {
        return this.a;
    }

    public final void setClosureType(ClosureType closureType) {
        this.a = closureType;
    }

    public EllipticalArcClose(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 19, cgmFile));
    }

    public EllipticalArcClose(CgmFile cgmFile, ClosureType closureType, double d2, double d3, double d4, double d5, CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3) {
        this(cgmFile);
        this.setClosureType(closureType);
        this.setValues(d2, d3, d4, d5, cgmPoint, cgmPoint2, cgmPoint3);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        super.readFromBinary(iBinaryReader);
        int n2 = iBinaryReader.readEnum();
        if (n2 == 0) {
            this.setClosureType(ClosureType.PIE);
        } else if (n2 == 1) {
            this.setClosureType(ClosureType.CHORD);
        } else {
            iBinaryReader.unsupported(aX.a(new String[]{"unsupported closure type ", av.b(n2)}));
            this.setClosureType(ClosureType.CHORD);
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        super.writeAsBinary(iBinaryWriter);
        iBinaryWriter.writeEnum(this.getClosureType().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  ELLIPARCCLOSE");
        this.writeValues(iClearTextWriter);
        iClearTextWriter.writeLine(";");
    }

    @Override
    protected void writeValues(IClearTextWriter iClearTextWriter) {
        super.writeValues(iClearTextWriter);
        iClearTextWriter.write(String.format(" %s)", EllipticalArcClose.a(this.getClosureType().toString())));
    }
}

