/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class EllipseElement
extends Command {
    private CgmPoint a;
    private CgmPoint b;
    private CgmPoint c;

    public final CgmPoint getCenter() {
        return this.a;
    }

    public final void setCenter(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final CgmPoint getFirstConjugateDiameterEndPoint() {
        return this.b;
    }

    public final void setFirstConjugateDiameterEndPoint(CgmPoint cgmPoint) {
        this.b = cgmPoint;
    }

    public final CgmPoint getSecondConjugateDiameterEndPoint() {
        return this.c;
    }

    public final void setSecondConjugateDiameterEndPoint(CgmPoint cgmPoint) {
        this.c = cgmPoint;
    }

    public EllipseElement(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 17, cgmFile));
    }

    public EllipseElement(CommandConstructorArguments commandConstructorArguments) {
        super(commandConstructorArguments);
    }

    public EllipseElement(CgmFile cgmFile, CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3) {
        this(cgmFile);
        this.setValues(cgmPoint, cgmPoint2, cgmPoint3);
    }

    protected final void setValues(CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3) {
        this.setCenter(cgmPoint);
        this.setFirstConjugateDiameterEndPoint(cgmPoint2);
        this.setSecondConjugateDiameterEndPoint(cgmPoint3);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setCenter(iBinaryReader.readPoint());
        this.setFirstConjugateDiameterEndPoint(iBinaryReader.readPoint());
        this.setSecondConjugateDiameterEndPoint(iBinaryReader.readPoint());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getCenter());
        iBinaryWriter.writePoint(this.getFirstConjugateDiameterEndPoint());
        iBinaryWriter.writePoint(this.getSecondConjugateDiameterEndPoint());
    }

    protected void writeValues(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(String.format(" %s", this.writePoint(this.getCenter().getX(), this.getCenter().getY())));
        iClearTextWriter.write(String.format(" %s", this.writePoint(this.getFirstConjugateDiameterEndPoint())));
        iClearTextWriter.write(String.format(" %s", this.writePoint(this.getSecondConjugateDiameterEndPoint())));
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  ELLIPSE");
        this.writeValues(iClearTextWriter);
        iClearTextWriter.writeLine(";");
    }
}

