/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmColor;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class EdgeRepresentation
extends Command {
    private int a;
    private int b;
    private double c;
    private CgmColor d;

    public final int getBundleIndex() {
        return this.a;
    }

    public final void setBundleIndex(int n2) {
        this.a = n2;
    }

    public final int getEdgeType() {
        return this.b;
    }

    public final void setEdgeType(int n2) {
        this.b = n2;
    }

    public final double getEdgeWidth() {
        return this.c;
    }

    public final void setEdgeWidth(double d2) {
        this.c = d2;
    }

    public final CgmColor getEdgeColor() {
        return this.d;
    }

    public final void setEdgeColor(CgmColor cgmColor) {
        this.d = cgmColor;
    }

    public EdgeRepresentation(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 15, cgmFile));
    }

    public EdgeRepresentation(CgmFile cgmFile, int n2, int n3, double d2, CgmColor cgmColor) {
        this(cgmFile);
        this.setBundleIndex(n2);
        this.setEdgeType(n3);
        this.setEdgeWidth(d2);
        this.setEdgeColor(cgmColor);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setBundleIndex(iBinaryReader.readIndex());
        this.setEdgeType(iBinaryReader.readIndex());
        this.setEdgeWidth(iBinaryReader.readSizeSpecification(this._container.getEdgeWidthSpecificationMode()));
        this.setEdgeColor(iBinaryReader.readColor());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getBundleIndex());
        iBinaryWriter.writeIndex(this.getEdgeType());
        iBinaryWriter.writeSizeSpecification(this.getEdgeWidth(), this._container.getEdgeWidthSpecificationMode());
        iBinaryWriter.writeColor(this.getEdgeColor());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" EDGEREP %s %s %s %s;", this.writeIndex(this.getBundleIndex()), this.writeIndex(this.getEdgeType()), this.writeVDC(this.getEdgeWidth()), this.writeColor(this.getEdgeColor())));
    }
}

