/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.ViewportPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class DeviceViewport
extends Command {
    private ViewportPoint a;
    private ViewportPoint b;

    public final ViewportPoint getFirstCorner() {
        return this.a;
    }

    public final void setFirstCorner(ViewportPoint viewportPoint) {
        this.a = viewportPoint;
    }

    public final ViewportPoint getSecondCorner() {
        return this.b;
    }

    public final void setSecondCorner(ViewportPoint viewportPoint) {
        this.b = viewportPoint;
    }

    public DeviceViewport(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 8, cgmFile));
    }

    public DeviceViewport(CgmFile cgmFile, ViewportPoint viewportPoint, ViewportPoint viewportPoint2) {
        this(cgmFile);
        this.setFirstCorner(viewportPoint);
        this.setSecondCorner(viewportPoint2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setFirstCorner(iBinaryReader.readViewportPoint());
        this.setSecondCorner(iBinaryReader.readViewportPoint());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeViewportPoint(this.getFirstCorner());
        iBinaryWriter.writeViewportPoint(this.getSecondCorner());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" DEVVP %s %s;", this.writeViewportPoint(this.getFirstCorner()), this.writeViewportPoint(this.getSecondCorner())));
    }
}

