/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class ClipRectangle
extends Command {
    private CgmPoint a;
    private CgmPoint b;

    public final CgmPoint getPoint1() {
        return this.a;
    }

    public final void setPoint1(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final CgmPoint getPoint2() {
        return this.b;
    }

    public final void setPoint2(CgmPoint cgmPoint) {
        this.b = cgmPoint;
    }

    public ClipRectangle(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.ControlElements, 5, cgmFile));
    }

    public ClipRectangle(CgmFile cgmFile, CgmPoint cgmPoint, CgmPoint cgmPoint2) {
        this(cgmFile);
        this.setPoint1(cgmPoint);
        this.setPoint2(cgmPoint2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setPoint1(iBinaryReader.readPoint());
        this.setPoint2(iBinaryReader.readPoint());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getPoint1());
        iBinaryWriter.writePoint(this.getPoint2());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" CLIPRECT %s %s;", this.writePoint(this.getPoint1()), this.writePoint(this.getPoint2())));
    }

    @Override
    public String toString() {
        return String.format("ClipRectangle [%s] [%s]", this.writePoint(this.getPoint1()), this.writePoint(this.getPoint2()));
    }
}

