/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class CircularArc3Point
extends Command {
    private CgmPoint a;
    private CgmPoint b;
    private CgmPoint c;

    public final CgmPoint getP1() {
        return this.a;
    }

    public final void setP1(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final CgmPoint getP2() {
        return this.b;
    }

    public final void setP2(CgmPoint cgmPoint) {
        this.b = cgmPoint;
    }

    public final CgmPoint getP3() {
        return this.c;
    }

    public final void setP3(CgmPoint cgmPoint) {
        this.c = cgmPoint;
    }

    public CircularArc3Point(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 13, cgmFile));
    }

    public CircularArc3Point(CgmFile cgmFile, CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3) {
        this(cgmFile);
        this.setP1(cgmPoint);
        this.setP2(cgmPoint2);
        this.setP3(cgmPoint3);
    }

    public CircularArc3Point(CommandConstructorArguments commandConstructorArguments) {
        super(commandConstructorArguments);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setP1(iBinaryReader.readPoint());
        this.setP2(iBinaryReader.readPoint());
        this.setP3(iBinaryReader.readPoint());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getP1());
        iBinaryWriter.writePoint(this.getP2());
        iBinaryWriter.writePoint(this.getP3());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" ARC3PT %s;", this.writeThreePointArcSpec()));
    }

    protected final String writeThreePointArcSpec() {
        return String.format("%s %s %s", this.writePoint(this.getP1()), this.writePoint(this.getP2()), this.writePoint(this.getP3()));
    }
}

