/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class CircleElement
extends Command {
    private CgmPoint a;
    private double b;

    public final CgmPoint getCenter() {
        return this.a;
    }

    private void a(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final double getRadius() {
        return this.b;
    }

    private void b(double d2) {
        this.b = d2;
    }

    public CircleElement(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 12, cgmFile));
    }

    public CircleElement(CgmFile cgmFile, CgmPoint cgmPoint, double d2) {
        this(cgmFile);
        this.a(cgmPoint);
        this.b(d2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.a(iBinaryReader.readPoint());
        this.b(iBinaryReader.readVdc());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getCenter());
        iBinaryWriter.writeVdc(this.getRadius());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format("  CIRCLE %s %s;", this.writePoint(this.getCenter()), this.writeVDC(this.getRadius())));
    }

    @Override
    public String toString() {
        return String.format("Circle %s %s", this.writePoint(this.getCenter()), this.writeVDC(this.getRadius()));
    }
}

