/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.Tuple;
import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.Exceptions.NotImplementedException;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.aq;
import com.aspose.cad.internal.N.av;
import com.aspose.cad.internal.N.g;
import com.aspose.cad.internal.aC.A;
import com.aspose.cad.internal.eT.d;
import com.aspose.cad.system.collections.Generic.IGenericEnumerator;
import com.aspose.cad.system.collections.Generic.List;

public class CharacterSetList
extends Command {
    private List<Tuple<Type, String>> a = new List();

    public final java.util.List<Tuple<Type, String>> getCharacterSets() {
        return List.toJava(this.a());
    }

    public final List<Tuple<Type, String>> a() {
        return this.a;
    }

    public CharacterSetList(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.MetafileDescriptorElements, 14, cgmFile));
    }

    public CharacterSetList(CgmFile cgmFile, Tuple<Type, String>[] tupleArray) {
        this(cgmFile);
        this.a().addRange(g.a(tupleArray));
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        while (iBinaryReader.getCurrentArg() < iBinaryReader.getArgumentsCount()) {
            Type type;
            int n2 = iBinaryReader.readEnum();
            switch (n2) {
                case 0: {
                    type = Type._94_CHAR_G_SET;
                    break;
                }
                case 1: {
                    type = Type._96_CHAR_G_SET;
                    break;
                }
                case 2: {
                    type = Type._94_CHAR_MBYTE_G_SET;
                    break;
                }
                case 3: {
                    type = Type._96_CHAR_MBYTE_G_SET;
                    break;
                }
                case 4: {
                    type = Type.COMPLETE_CODE;
                    break;
                }
                default: {
                    type = Type.COMPLETE_CODE;
                    iBinaryReader.unsupported(aX.a(new String[]{"unsupported character set type ", av.b(n2)}));
                }
            }
            String string = iBinaryReader.readFixedString();
            this.a().addItem(new Tuple<Type, String>(type, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Tuple tuple = (Tuple)iGenericEnumerator.next();
                iBinaryWriter.writeEnum(((Type)((Object)tuple.getItem1())).ordinal());
                iBinaryWriter.writeString((String)tuple.getItem2());
            }
        }
        finally {
            if (d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(" charsetlist");
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Tuple tuple = (Tuple)iGenericEnumerator.next();
                switch ((Type)((Object)tuple.getItem1())) {
                    case _94_CHAR_G_SET: {
                        iClearTextWriter.write(" STD94 ");
                        break;
                    }
                    case _96_CHAR_G_SET: {
                        iClearTextWriter.write(" STD96 ");
                        break;
                    }
                    case _94_CHAR_MBYTE_G_SET: {
                        iClearTextWriter.write(" STD94MULTIBYTE ");
                        break;
                    }
                    case _96_CHAR_MBYTE_G_SET: {
                        iClearTextWriter.write(" STD96MULTIBYTE ");
                        break;
                    }
                    case COMPLETE_CODE: {
                        iClearTextWriter.write(" COMPLETECODE ");
                        break;
                    }
                    default: {
                        throw new NotImplementedException(String.format("Charsetlist type %s not supported.", tuple.getItem2()));
                    }
                }
                iClearTextWriter.write(this.writeString((String)tuple.getItem2()));
            }
        }
        finally {
            if (d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
        iClearTextWriter.writeLine(";");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        A a2 = new A();
        a2.a("CharacterSetList ");
        IGenericEnumerator iGenericEnumerator = this.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Tuple tuple = (Tuple)iGenericEnumerator.next();
                a2.a(String.format("[%d,%s]", tuple.getItem1(), tuple.getItem2()));
            }
        }
        finally {
            if (d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
        return a2.toString();
    }

    public static enum Type {
        _94_CHAR_G_SET,
        _96_CHAR_G_SET,
        _94_CHAR_MBYTE_G_SET,
        _96_CHAR_MBYTE_G_SET,
        COMPLETE_CODE;

    }
}

