/*
 * Decompiled with CFR 0.152.
 */
package com.aseem.versatileprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aseem.versatileprogressbar.R;
import com.bumptech.glide.Glide;

public class ProgBar
extends RelativeLayout {
    private Context mContext;
    private AttributeSet attrs;
    private int styleAttr;
    private ImageView imageView;
    private Drawable imageFile;
    private View view;
    private View progBg;
    private TextView textMsg;
    private String customMsg;
    private int textColor;
    private int enlarge;
    private float textSize;

    public ProgBar(Context context) {
        super(context);
        this.initView();
    }

    public ProgBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.attrs = attrs;
        this.initView();
    }

    public ProgBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.attrs = attrs;
        this.styleAttr = defStyleAttr;
        this.initView();
    }

    private void initView() {
        this.view = this;
        ProgBar.inflate((Context)this.mContext, (int)R.layout.progress_bar_layout, (ViewGroup)this);
        TypedArray arr = this.mContext.obtainStyledAttributes(this.attrs, R.styleable.ProgBar, this.styleAttr, 0);
        this.imageFile = arr.getDrawable(R.styleable.ProgBar_barType);
        this.customMsg = arr.getString(R.styleable.ProgBar_text);
        this.textColor = arr.getColor(R.styleable.ProgBar_androidtextColor, -16777216);
        this.textSize = arr.getDimension(R.styleable.ProgBar_textSize, 16.0f);
        this.enlarge = arr.getInt(R.styleable.ProgBar_enlarge, 2);
        this.imageView = (ImageView)this.findViewById(R.id.progressImg);
        this.progBg = this.findViewById(R.id.progBg);
        this.textMsg = (TextView)this.findViewById(R.id.textMsg);
        if (this.imageFile != null) {
            this.setProgressVector(this.imageFile);
        }
        if (this.customMsg != null) {
            this.setTextMsg(this.customMsg);
        }
        this.setTextColor(this.textColor);
        this.setTextSize(this.textSize);
        this.enlarge(this.enlarge);
        arr.recycle();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.imageView.setScaleType(scaleType);
    }

    public void setProgressVector(Drawable imageFile) {
        Glide.with((Context)this.mContext).load(imageFile).into(this.imageView);
    }

    public void enlarge(int enlarge) {
        if (enlarge >= 1 && enlarge <= 10) {
            this.imageView.getLayoutParams().height = enlarge * 100;
        }
    }

    public void setTextMsg(String message) {
        this.textMsg.setText((CharSequence)message);
    }

    public void setTextColor(int color) {
        this.textMsg.setTextColor(color);
    }

    public void setTextSize(float size) {
        this.textMsg.setTextSize(2, size);
    }
}

