/*
 * Decompiled with CFR 0.152.
 */
package com.aseem.versatileprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.aseem.versatileprogressbar.R;
import com.bumptech.glide.Glide;

public class ProgBar
extends RelativeLayout {
    private Context mContext;
    private AttributeSet attrs;
    private int styleAttr;
    private ImageView imageView;
    private Drawable imageFile;
    private View view;

    public ProgBar(Context context) {
        super(context);
        this.initView();
    }

    public ProgBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.attrs = attrs;
        this.initView();
    }

    public ProgBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.attrs = attrs;
        this.styleAttr = defStyleAttr;
        this.initView();
    }

    private void initView() {
        this.view = this;
        ProgBar.inflate((Context)this.mContext, (int)R.layout.progress_bar_layout, (ViewGroup)this);
        TypedArray arr = this.mContext.obtainStyledAttributes(this.attrs, R.styleable.ProgBar, this.styleAttr, 0);
        this.imageFile = arr.getDrawable(R.styleable.ProgBar_barType);
        this.imageView = (ImageView)this.findViewById(R.id.progressImg);
        if (this.imageFile != null) {
            this.setProgressVector(this.imageFile);
        }
        arr.recycle();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.imageView.setScaleType(scaleType);
    }

    public void setProgressVector(Drawable imageFile) {
        Glide.with((Context)this.mContext).load(imageFile).into(this.imageView);
    }

    public void setHeight(int height) {
        this.imageView.getLayoutParams().height = height;
    }
}

