/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto.core.jce;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.KeyAgreement;

public final class ECKeyAgreement {
    public static final String ALGORITHM = "ECDH";
    private static final String algorithmAssertionMsg = "Assumed the JRE supports EC key agreement";

    private ECKeyAgreement() {
    }

    public static KeyAgreement getInstance() {
        try {
            return KeyAgreement.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError(algorithmAssertionMsg, ex);
        }
    }

    public static KeyAgreement getInstance(String provider) throws NoSuchProviderException {
        try {
            return KeyAgreement.getInstance(ALGORITHM, provider);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError(algorithmAssertionMsg, ex);
        }
    }

    public static KeyAgreement getInstance(Provider provider) {
        try {
            return KeyAgreement.getInstance(ALGORITHM, provider);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError(algorithmAssertionMsg, ex);
        }
    }
}

