/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto;

import com.arxanfintech.common.crypto.Cryptography;
import com.arxanfintech.common.crypto.Key;
import com.arxanfintech.common.crypto.PublicKey;
import java.math.BigInteger;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKey
implements Key {
    private static final Logger log = LoggerFactory.getLogger(PrivateKey.class);
    private final byte[] priv;
    private final Cryptography crypto;
    private PublicKey publicKey = null;

    private PrivateKey(byte[] priv, Cryptography crypto) {
        this.priv = priv;
        this.crypto = crypto;
    }

    public static PrivateKey createNew(Cryptography crypto) {
        return new PrivateKey(crypto.createNewPrivateKey(), crypto);
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])this.priv.clone();
    }

    public PublicKey getPublic() {
        if (this.publicKey == null) {
            this.publicKey = new PublicKey(this.crypto.getPublicFor(this.priv), this.crypto);
        }
        return this.publicKey;
    }

    public byte[] sign(byte[] hash) {
        return this.crypto.sign(hash, this.toByteArray());
    }

    public String toString() {
        return "private key of " + this.getPublic();
    }

    @Override
    public PrivateKey offsetKey(BigInteger offset) {
        return new PrivateKey(this.crypto.getPrivateKeyAtOffset(this.priv, offset.toByteArray()), this.crypto);
    }

    public int hashCode() {
        return Arrays.hashCode(this.priv);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrivateKey) {
            PrivateKey other = (PrivateKey)obj;
            return Arrays.equals(this.priv, other.priv);
        }
        return false;
    }
}

