/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.pqc.math.ntru.polynomial;

import org.spongycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.spongycastle.util.Arrays;

public class LongPolynomial2 {
    private long[] coeffs;
    private int numCoeffs;

    public LongPolynomial2(IntegerPolynomial p) {
        this.numCoeffs = p.coeffs.length;
        this.coeffs = new long[(this.numCoeffs + 1) / 2];
        int idx = 0;
        int pIdx = 0;
        while (pIdx < this.numCoeffs) {
            long c1;
            int c0;
            for (c0 = p.coeffs[pIdx++]; c0 < 0; c0 += 2048) {
            }
            long l = c1 = pIdx < this.numCoeffs ? (long)p.coeffs[pIdx++] : 0L;
            while (c1 < 0L) {
                c1 += 2048L;
            }
            this.coeffs[idx] = (long)c0 + (c1 << 24);
            ++idx;
        }
    }

    private LongPolynomial2(long[] coeffs) {
        this.coeffs = coeffs;
    }

    private LongPolynomial2(int N) {
        this.coeffs = new long[N];
    }

    public LongPolynomial2 mult(LongPolynomial2 poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N || this.numCoeffs != poly2.numCoeffs) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        LongPolynomial2 c = this.multRecursive(poly2);
        if (c.coeffs.length > N) {
            if (this.numCoeffs % 2 == 0) {
                for (int k = N; k < c.coeffs.length; ++k) {
                    c.coeffs[k - N] = c.coeffs[k - N] + c.coeffs[k] & 0x7FF0007FFL;
                }
                c.coeffs = Arrays.copyOf(c.coeffs, N);
            } else {
                for (int k = N; k < c.coeffs.length; ++k) {
                    c.coeffs[k - N] = c.coeffs[k - N] + (c.coeffs[k - 1] >> 24);
                    c.coeffs[k - N] = c.coeffs[k - N] + ((c.coeffs[k] & 0x7FFL) << 24);
                    int n = k - N;
                    c.coeffs[n] = c.coeffs[n] & 0x7FF0007FFL;
                }
                c.coeffs = Arrays.copyOf(c.coeffs, N);
                int n = c.coeffs.length - 1;
                c.coeffs[n] = c.coeffs[n] & 0x7FFL;
            }
        }
        c = new LongPolynomial2(c.coeffs);
        c.numCoeffs = this.numCoeffs;
        return c;
    }

    public IntegerPolynomial toIntegerPolynomial() {
        int[] intCoeffs = new int[this.numCoeffs];
        int uIdx = 0;
        for (int i = 0; i < this.coeffs.length; ++i) {
            intCoeffs[uIdx++] = (int)(this.coeffs[i] & 0x7FFL);
            if (uIdx >= this.numCoeffs) continue;
            intCoeffs[uIdx++] = (int)(this.coeffs[i] >> 24 & 0x7FFL);
        }
        return new IntegerPolynomial(intCoeffs);
    }

    private LongPolynomial2 multRecursive(LongPolynomial2 poly2) {
        int i;
        long[] a = this.coeffs;
        long[] b = poly2.coeffs;
        int n = poly2.coeffs.length;
        if (n <= 32) {
            int cn = 2 * n;
            LongPolynomial2 c = new LongPolynomial2(new long[cn]);
            for (int k = 0; k < cn; ++k) {
                for (int i2 = Math.max(0, k - n + 1); i2 <= Math.min(k, n - 1); ++i2) {
                    long c0 = a[k - i2] * b[i2];
                    long cu = c0 & 0x7FF000000L + (c0 & 0x7FFL);
                    long co = c0 >>> 48 & 0x7FFL;
                    c.coeffs[k] = c.coeffs[k] + cu & 0x7FF0007FFL;
                    c.coeffs[k + 1] = c.coeffs[k + 1] + co & 0x7FF0007FFL;
                }
            }
            return c;
        }
        int n1 = n / 2;
        LongPolynomial2 a1 = new LongPolynomial2(Arrays.copyOf(a, n1));
        LongPolynomial2 a2 = new LongPolynomial2(Arrays.copyOfRange(a, n1, n));
        LongPolynomial2 b1 = new LongPolynomial2(Arrays.copyOf(b, n1));
        LongPolynomial2 b2 = new LongPolynomial2(Arrays.copyOfRange(b, n1, n));
        LongPolynomial2 A = (LongPolynomial2)a1.clone();
        A.add(a2);
        LongPolynomial2 B = (LongPolynomial2)b1.clone();
        B.add(b2);
        LongPolynomial2 c1 = a1.multRecursive(b1);
        LongPolynomial2 c2 = a2.multRecursive(b2);
        LongPolynomial2 c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        LongPolynomial2 c = new LongPolynomial2(2 * n);
        for (i = 0; i < c1.coeffs.length; ++i) {
            c.coeffs[i] = c1.coeffs[i] & 0x7FF0007FFL;
        }
        for (i = 0; i < c3.coeffs.length; ++i) {
            c.coeffs[n1 + i] = c.coeffs[n1 + i] + c3.coeffs[i] & 0x7FF0007FFL;
        }
        for (i = 0; i < c2.coeffs.length; ++i) {
            c.coeffs[2 * n1 + i] = c.coeffs[2 * n1 + i] + c2.coeffs[i] & 0x7FF0007FFL;
        }
        return c;
    }

    private void add(LongPolynomial2 b) {
        if (b.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b.coeffs.length);
        }
        for (int i = 0; i < b.coeffs.length; ++i) {
            this.coeffs[i] = this.coeffs[i] + b.coeffs[i] & 0x7FF0007FFL;
        }
    }

    private void sub(LongPolynomial2 b) {
        if (b.coeffs.length > this.coeffs.length) {
            this.coeffs = Arrays.copyOf(this.coeffs, b.coeffs.length);
        }
        for (int i = 0; i < b.coeffs.length; ++i) {
            this.coeffs[i] = 0x800000800000L + this.coeffs[i] - b.coeffs[i] & 0x7FF0007FFL;
        }
    }

    public void subAnd(LongPolynomial2 b, int mask) {
        long longMask = ((long)mask << 24) + (long)mask;
        for (int i = 0; i < b.coeffs.length; ++i) {
            this.coeffs[i] = 0x800000800000L + this.coeffs[i] - b.coeffs[i] & longMask;
        }
    }

    public void mult2And(int mask) {
        long longMask = ((long)mask << 24) + (long)mask;
        for (int i = 0; i < this.coeffs.length; ++i) {
            this.coeffs[i] = this.coeffs[i] << 1 & longMask;
        }
    }

    public Object clone() {
        LongPolynomial2 p = new LongPolynomial2((long[])this.coeffs.clone());
        p.numCoeffs = this.numCoeffs;
        return p;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongPolynomial2) {
            return Arrays.areEqual(this.coeffs, ((LongPolynomial2)obj).coeffs);
        }
        return false;
    }
}

