/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.asn1.nist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.sec.SECNamedCurves;
import org.spongycastle.asn1.sec.SECObjectIdentifiers;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.util.Strings;

public class NISTNamedCurves {
    static final Hashtable objIds = new Hashtable();
    static final Hashtable names = new Hashtable();

    static void defineCurveAlias(String name, ASN1ObjectIdentifier oid) {
        objIds.put(name.toUpperCase(), oid);
        names.put(oid, name);
    }

    public static X9ECParameters getByName(String name) {
        ASN1ObjectIdentifier oid = NISTNamedCurves.getOID(name);
        return oid == null ? null : NISTNamedCurves.getByOID(oid);
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        return SECNamedCurves.getByOID(oid);
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        return (ASN1ObjectIdentifier)objIds.get(Strings.toUpperCase(name));
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        return (String)names.get(oid);
    }

    public static Enumeration getNames() {
        return names.elements();
    }

    static {
        NISTNamedCurves.defineCurveAlias("B-163", SECObjectIdentifiers.sect163r2);
        NISTNamedCurves.defineCurveAlias("B-233", SECObjectIdentifiers.sect233r1);
        NISTNamedCurves.defineCurveAlias("B-283", SECObjectIdentifiers.sect283r1);
        NISTNamedCurves.defineCurveAlias("B-409", SECObjectIdentifiers.sect409r1);
        NISTNamedCurves.defineCurveAlias("B-571", SECObjectIdentifiers.sect571r1);
        NISTNamedCurves.defineCurveAlias("K-163", SECObjectIdentifiers.sect163k1);
        NISTNamedCurves.defineCurveAlias("K-233", SECObjectIdentifiers.sect233k1);
        NISTNamedCurves.defineCurveAlias("K-283", SECObjectIdentifiers.sect283k1);
        NISTNamedCurves.defineCurveAlias("K-409", SECObjectIdentifiers.sect409k1);
        NISTNamedCurves.defineCurveAlias("K-571", SECObjectIdentifiers.sect571k1);
        NISTNamedCurves.defineCurveAlias("P-192", SECObjectIdentifiers.secp192r1);
        NISTNamedCurves.defineCurveAlias("P-224", SECObjectIdentifiers.secp224r1);
        NISTNamedCurves.defineCurveAlias("P-256", SECObjectIdentifiers.secp256r1);
        NISTNamedCurves.defineCurveAlias("P-384", SECObjectIdentifiers.secp384r1);
        NISTNamedCurves.defineCurveAlias("P-521", SECObjectIdentifiers.secp521r1);
    }
}

