/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto;

import com.arxanfintech.common.crypto.Cryptography;
import com.arxanfintech.common.crypto.Key;
import com.arxanfintech.common.util.ByteUtils;
import java.math.BigInteger;
import java.util.Arrays;

public class PublicKey
implements Key {
    private final Cryptography crypto;
    private final byte[] pub;

    public PublicKey(byte[] pub, Cryptography crypto) {
        this.pub = pub;
        this.crypto = crypto;
    }

    public static PublicKey fromCompressed(byte[] pub, Cryptography crypto) {
        return new PublicKey(crypto.uncompressPoint(pub), crypto);
    }

    @Override
    public byte[] toByteArray() {
        return (byte[])this.pub.clone();
    }

    public boolean verify(byte[] hash, byte[] signature) {
        return this.crypto.verify(hash, signature, this.pub);
    }

    @Override
    public PublicKey offsetKey(BigInteger offset) {
        byte[] atOffset = this.crypto.getPublicKeyAtOffset(this.pub, offset.toByteArray());
        return PublicKey.fromCompressed(atOffset, this.crypto);
    }

    public int hashCode() {
        return Arrays.hashCode(this.pub);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PublicKey) {
            PublicKey other = (PublicKey)obj;
            return Arrays.equals(this.pub, other.pub);
        }
        return false;
    }

    public String toString() {
        return ByteUtils.toHex(this.pub);
    }
}

