/*
 * Decompiled with CFR 0.152.
 */
package com.arxanfintech.common.crypto;

import com.arxanfintech.common.crypto.CertTool;
import com.arxanfintech.common.crypto.core.ECIESCoder;
import com.arxanfintech.common.crypto.core.jce.SpongyCastleProvider;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.spongycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class Crypto {
    private byte[] ePrivKeyBytes = null;
    private byte[] tlsCertBytes = null;
    private X509Certificate tlsCert = null;
    private PublicKey tlsPubKey = null;
    private PrivateKey ePrivKey = null;

    public Crypto(InputStream epkIS, InputStream tcIS) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this(IOUtils.toByteArray(epkIS), IOUtils.toByteArray(tcIS));
    }

    public Crypto(byte[] ePrivKeyBytes, byte[] tlsCertBytes) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.ePrivKeyBytes = ePrivKeyBytes;
        this.tlsCertBytes = tlsCertBytes;
        this.init();
    }

    private void init() throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.tlsCert = CertTool.getCertfromPEM(this.tlsCertBytes);
        this.tlsPubKey = this.tlsCert.getPublicKey();
        BufferedReader fRd = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.ePrivKeyBytes)));
        PEMParser pemRd = new PEMParser(fRd);
        PEMKeyPair pemPair = (PEMKeyPair)pemRd.readObject();
        KeyPair pair = new JcaPEMKeyConverter().setProvider("SC").getKeyPair(pemPair);
        this.ePrivKey = pair.getPrivate();
    }

    public byte[] getEPrivKeyBytes() {
        return this.ePrivKeyBytes;
    }

    public byte[] getTlsCertBytes() {
        return this.tlsCertBytes;
    }

    public X509Certificate getTlsCert() {
        return this.tlsCert;
    }

    private byte[] signData(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature sgr = Signature.getInstance("SHA3-256withECDSA", "BC");
        sgr.initSign(this.ePrivKey);
        sgr.update(data);
        return sgr.sign();
    }

    private boolean verifyData(byte[] data, byte[] signature) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature sgr = Signature.getInstance("SHA3-256withECDSA", "BC");
        sgr.initVerify(this.tlsPubKey);
        sgr.update(data);
        return sgr.verify(signature);
    }

    public String signDataWithBase64(byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        String res = null;
        byte[] signature = this.signData(data);
        res = Base64.toBase64String(signature);
        return res;
    }

    private byte[] encryptBytes(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidCipherTextException, IOException {
        BCECPublicKey ecPub = (BCECPublicKey)this.tlsPubKey;
        byte[] cipherData = ECIESCoder.encrypt(ecPub.getQ(), data);
        return cipherData;
    }

    private byte[] decryptBytes(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidCipherTextException, IOException {
        BCECPrivateKey ecPrivate = (BCECPrivateKey)this.ePrivKey;
        return ECIESCoder.decrypt(ecPrivate.getD(), data);
    }

    public String encryptWithBase64(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidCipherTextException, IOException {
        byte[] cipher = this.encryptBytes(data);
        return Base64.toBase64String(cipher);
    }

    public String signAndEncrypt(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, SignatureException, InvalidAlgorithmParameterException, InvalidCipherTextException, IOException {
        String dataBase64 = Base64.toBase64String(data);
        String signBase64 = this.signDataWithBase64(data);
        JSONObject json = new JSONObject();
        json.put("data", dataBase64);
        json.put("signature", signBase64);
        String dataStr = json.toString();
        String cipher = this.encryptWithBase64(dataStr.getBytes());
        return cipher;
    }

    public String decryptAndVerify(byte[] data) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, SignatureException, InvalidAlgorithmParameterException, InvalidCipherTextException, IOException {
        byte[] signature;
        byte[] base64DecodedData = Base64.decode(data);
        byte[] decryptedData = this.decryptBytes(base64DecodedData);
        JSONObject json = new JSONObject(new String(decryptedData));
        String base64Data = json.getString("data");
        String base64Sign = json.getString("signature");
        byte[] oriData = Base64.decode(base64Data.getBytes());
        boolean verifyOK = this.verifyData(oriData, signature = Base64.decode(base64Sign.getBytes()));
        if (!verifyOK) {
            return null;
        }
        return new String(oriData);
    }

    static {
        Security.addProvider(SpongyCastleProvider.getInstance());
        Security.addProvider(new BouncyCastleProvider());
    }
}

