/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.xrecyclerview.adapter;

import android.content.Context;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.art.uilibrary.R;
import com.art.uilibrary.base.IAdapterListener;
import com.art.uilibrary.xrecyclerview.adapter.RecycleViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class RecycleViewAdapter<T>
extends RecyclerView.Adapter<RecycleViewHolder> {
    protected Context mContext;
    protected List<T> list;
    private static final int HEADER_VIEW_TYPE = -500;
    private static final int EMPTY_VIEW_TYPE = -1000;
    private int mEmptyLayoutResId = 0;
    private int mHeadLayoutResId = 0;
    private View headView;
    private int mLayoutResId;
    private IAdapterListener.IOnChildClickListener mChildClickListener;
    private IAdapterListener.IOnItemClickListener mItemClickListener;
    private LayoutInflater mInflater;

    public void setHeadLayoutResID(int headLayoutResId) {
        this.mHeadLayoutResId = headLayoutResId;
    }

    public void addheadView(View headView) {
        this.headView = headView;
    }

    public RecycleViewAdapter(Context context, int layoutResId) {
        this.mContext = context;
        this.mLayoutResId = layoutResId;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        this.list = new ArrayList<T>();
    }

    public RecycleViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecycleViewHolder holder;
        if (viewType == -500) {
            if (this.headView == null) {
                View headView = this.mInflater.inflate(this.mHeadLayoutResId, parent, false);
                holder = new RecycleViewHolder(headView);
            } else {
                holder = new RecycleViewHolder(this.headView);
            }
        } else if (viewType == -1000) {
            View emptyView = this.mInflater.inflate(this.mEmptyLayoutResId, parent, false);
            holder = new RecycleViewHolder(emptyView);
        } else {
            View itemView = this.mInflater.inflate(this.mLayoutResId, parent, false);
            holder = new RecycleViewHolder(itemView);
        }
        return holder;
    }

    public void onBindViewHolder(RecycleViewHolder holder, int position) {
        this.setOnChildClickListener((View)holder.getElement(R.id.layout), position);
        if (this.list != null && this.list.size() > 0) {
            if (this.mHeadLayoutResId != 0) {
                if (position > 0) {
                    this.convert(holder, this.list.get(position - 1), position - 1);
                }
            } else {
                this.convert(holder, this.list.get(position), position);
            }
        }
    }

    public void appendList(List<T> beanList) {
        if (beanList == null || beanList.size() == 0) {
            return;
        }
        int positionStart = this.list.size();
        this.list.addAll(beanList);
        int itemCount = beanList.size();
        if (positionStart == 0) {
            this.notifyDataSetChanged();
        } else {
            this.notifyItemRangeChanged(positionStart, itemCount + 1);
        }
    }

    public int getItemCount() {
        if (this.list == null) {
            if (this.mEmptyLayoutResId != 0 || this.mHeadLayoutResId != 0) {
                return 1;
            }
            return 0;
        }
        if (this.list.size() == 0 && this.mEmptyLayoutResId != 0) {
            return 1;
        }
        if (this.mHeadLayoutResId != 0) {
            return this.list.size() + 1;
        }
        return this.list.size();
    }

    public int getItemViewType(int position) {
        if (position == 0 && (this.mHeadLayoutResId != 0 || this.headView != null)) {
            return -500;
        }
        if ((this.list == null || this.list.size() == 0) && this.mEmptyLayoutResId != 0) {
            return -1000;
        }
        return super.getItemViewType(position);
    }

    public void invalidateData(List<T> list) {
        this.list = list;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.notifyDataSetChanged();
        }
    }

    protected abstract void convert(RecycleViewHolder var1, T var2, int var3);

    public void setEmptyView(int layoutResID) {
        this.mEmptyLayoutResId = layoutResID;
    }

    public void setOnChildClickListener(IAdapterListener.IOnChildClickListener listener) {
        this.mChildClickListener = listener;
    }

    public void setItemClickListener(IAdapterListener.IOnItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    protected void setOnChildClickListener(View view, final Object data) {
        if (view == null) {
            return;
        }
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RecycleViewAdapter.this.mChildClickListener.onChildClickListener(data);
            }
        });
    }

    protected <TT, TD> void setOnItemClickListener(View view, final TT type, final TD ... data) {
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RecycleViewAdapter.this.mItemClickListener.onItemClickListener(type, data);
            }
        });
    }
}

