/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import com.art.uilibrary.R;

public class ClearEditText
extends EditText
implements View.OnFocusChangeListener,
TextWatcher {
    private Drawable mClearDrawable;
    private boolean hasFoucs;

    public ClearEditText(Context context) {
        this(context, null);
    }

    public ClearEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public ClearEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void setHasFoucs(boolean hasFoucs) {
        this.hasFoucs = hasFoucs;
    }

    private void init() {
        this.mClearDrawable = this.getCompoundDrawables()[2];
        if (this.mClearDrawable == null) {
            this.mClearDrawable = this.getResources().getDrawable(R.mipmap.btn_edt_clear);
        }
        this.mClearDrawable.setBounds(0, 0, this.mClearDrawable.getIntrinsicWidth(), this.mClearDrawable.getIntrinsicHeight());
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1 && this.getCompoundDrawables()[2] != null) {
            boolean touchable;
            boolean bl = touchable = event.getX() > (float)(this.getWidth() - this.getTotalPaddingRight()) && event.getX() < (float)(this.getWidth() - this.getPaddingRight());
            if (touchable) {
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        this.hasFoucs = hasFocus;
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
    }

    public void setClearIconVisible(boolean visible) {
        Drawable right = visible ? this.mClearDrawable : null;
        this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], right, this.getCompoundDrawables()[3]);
    }

    public void onTextChanged(CharSequence s, int start, int count, int after) {
        if (this.hasFoucs) {
            this.setClearIconVisible(s.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    public void setShakeAnimation() {
        this.setAnimation(ClearEditText.shakeAnimation(5));
    }

    public static Animation shakeAnimation(int counts) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)counts));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }
}

