/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.viewpager;

import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import com.art.uilibrary.viewpager.RecycleBin;

public abstract class RecyclingPagerAdapter
extends PagerAdapter {
    private static final int IGNORE_ITEM_VIEW_TYPE = -1;
    private final RecycleBin recycleBin;

    public RecyclingPagerAdapter() {
        this(new RecycleBin());
    }

    private RecyclingPagerAdapter(RecycleBin recycleBin) {
        this.recycleBin = recycleBin;
        recycleBin.setViewTypeCount(this.getViewTypeCount());
    }

    public void notifyDataSetChanged() {
        this.recycleBin.scrapActiveViews();
        super.notifyDataSetChanged();
    }

    public final Object instantiateItem(ViewGroup container, int position) {
        int viewType = this.getItemViewType(position);
        View view = null;
        if (viewType != -1) {
            view = this.recycleBin.getScrapView(position, viewType);
        }
        view = this.getView(position, view, container);
        container.addView(view);
        return view;
    }

    public final void destroyItem(ViewGroup container, int position, Object object) {
        View view = (View)object;
        container.removeView(view);
        int viewType = this.getItemViewType(position);
        if (viewType != -1) {
            this.recycleBin.addScrapView(view, position, viewType);
        }
    }

    public final boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    private int getViewTypeCount() {
        return 1;
    }

    private int getItemViewType(int position) {
        return 0;
    }

    public abstract View getView(int var1, View var2, ViewGroup var3);
}

