/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.viewpager;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.art.uilibrary.viewpager.CustomDurationScroller;
import java.lang.reflect.Field;

public class AutoScrollViewPager
extends ViewPager {
    private static final int DEFAULT_INTERVAL = 1500;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    public static final int SLIDE_BORDER_MODE_NONE = 0;
    private static final int SLIDE_BORDER_MODE_CYCLE = 1;
    private static final int SLIDE_BORDER_MODE_TO_PARENT = 2;
    private static final int SCROLL_WHAT = 0;
    private long interval = 1500L;
    private int direction = 1;
    private boolean isCycle = true;
    private boolean stopScrollWhenTouch = true;
    private int slideBorderMode = 2;
    private boolean isBorderAnimation = true;
    private Handler handler;
    private boolean isAutoScroll = false;
    private boolean isStopByTouch = false;
    private float downX = 0.0f;
    private CustomDurationScroller scroller = null;

    public AutoScrollViewPager(Context paramContext) {
        super(paramContext);
        this.init();
    }

    public AutoScrollViewPager(Context paramContext, AttributeSet paramAttributeSet) {
        super(paramContext, paramAttributeSet);
        this.init();
    }

    private void init() {
        this.handler = new MyHandler();
        this.setViewPagerScroller();
    }

    private void startAutoScroll() {
        this.isAutoScroll = true;
        this.sendScrollMessage(this.interval);
    }

    public void startAutoScroll(int delayTimeInMills) {
        this.isAutoScroll = true;
        this.sendScrollMessage(delayTimeInMills);
    }

    private void stopAutoScroll() {
        this.isAutoScroll = false;
        this.handler.removeMessages(0);
    }

    public void ScrollPrePager(int i) {
        Message msg = new Message();
        Bundle data = new Bundle();
        data.putInt("num", i);
        msg.setData(data);
        msg.what = 1;
        this.handler.sendMessage(msg);
    }

    public void ScrollNextPager() {
        this.handler.sendEmptyMessage(2);
    }

    public void setScrollDurationFactor(double scrollFactor) {
        this.scroller.setScrollDurationFactor(scrollFactor);
    }

    private void sendScrollMessage(long delayTimeInMills) {
        this.handler.removeMessages(0);
        this.handler.sendEmptyMessageDelayed(0, delayTimeInMills);
    }

    private void setViewPagerScroller() {
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            Field interpolatorField = ViewPager.class.getDeclaredField("sInterpolator");
            interpolatorField.setAccessible(true);
            this.scroller = new CustomDurationScroller(this.getContext(), (Interpolator)interpolatorField.get(null));
            scrollerField.set((Object)this, (Object)this.scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scrollOnce() {
        int nextItem;
        int totalCount;
        PagerAdapter adapter = this.getAdapter();
        int currentItem = this.getCurrentItem();
        if (adapter == null || (totalCount = adapter.getCount()) <= 1) {
            return;
        }
        int n = nextItem = this.direction == 0 ? --currentItem : ++currentItem;
        if (nextItem < 0) {
            if (this.isCycle) {
                this.setCurrentItem(totalCount - 1, this.isBorderAnimation);
            }
        } else if (nextItem == totalCount) {
            if (this.isCycle) {
                this.setCurrentItem(0, this.isBorderAnimation);
            }
        } else {
            this.setCurrentItem(nextItem, true);
        }
    }

    private void scrollPre(int i) {
        int totalCount;
        PagerAdapter adapter = this.getAdapter();
        int currentItem = this.getCurrentItem();
        if (adapter == null || (totalCount = adapter.getCount()) <= 1) {
            return;
        }
        int nextItem = currentItem -= i;
        if (nextItem < 0) {
            if (this.isCycle) {
                this.setCurrentItem(totalCount - 1, this.isBorderAnimation);
            }
        } else if (nextItem == totalCount) {
            if (this.isCycle) {
                this.setCurrentItem(0, this.isBorderAnimation);
            }
        } else {
            this.setCurrentItem(nextItem, true);
        }
    }

    private void scrollNext() {
        int nextItem;
        int totalCount;
        PagerAdapter adapter = this.getAdapter();
        int currentItem = this.getCurrentItem();
        if (adapter == null || (totalCount = adapter.getCount()) <= 1) {
            return;
        }
        if ((nextItem = ++currentItem) < 0) {
            if (this.isCycle) {
                this.setCurrentItem(totalCount - 1, this.isBorderAnimation);
            }
        } else if (nextItem == totalCount) {
            if (this.isCycle) {
                this.setCurrentItem(0, this.isBorderAnimation);
            }
        } else {
            this.setCurrentItem(nextItem, true);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.stopScrollWhenTouch) {
            if (ev.getAction() == 0 && this.isAutoScroll) {
                this.isStopByTouch = true;
                this.stopAutoScroll();
            } else if (ev.getAction() == 1 && this.isStopByTouch) {
                this.startAutoScroll();
            }
        }
        if (this.slideBorderMode == 2 || this.slideBorderMode == 1) {
            int pageCount;
            float touchX = ev.getX();
            if (ev.getAction() == 0) {
                this.downX = touchX;
            }
            int currentItem = this.getCurrentItem();
            PagerAdapter adapter = this.getAdapter();
            int n = pageCount = adapter == null ? 0 : adapter.getCount();
            if (currentItem == 0 && this.downX <= touchX || currentItem == pageCount - 1 && this.downX >= touchX) {
                if (this.slideBorderMode == 2) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                } else {
                    if (pageCount > 1) {
                        this.setCurrentItem(pageCount - currentItem - 1, this.isBorderAnimation);
                    }
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                return super.onTouchEvent(ev);
            }
        }
        this.getParent().requestDisallowInterceptTouchEvent(true);
        return super.onTouchEvent(ev);
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public int getDirection() {
        return this.direction == 0 ? 0 : 1;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public boolean isCycle() {
        return this.isCycle;
    }

    public void setCycle(boolean isCycle) {
        this.isCycle = isCycle;
    }

    public boolean isStopScrollWhenTouch() {
        return this.stopScrollWhenTouch;
    }

    public void setStopScrollWhenTouch(boolean stopScrollWhenTouch) {
        this.stopScrollWhenTouch = stopScrollWhenTouch;
    }

    public int getSlideBorderMode() {
        return this.slideBorderMode;
    }

    public void setSlideBorderMode(int slideBorderMode) {
        this.slideBorderMode = slideBorderMode;
    }

    public boolean isBorderAnimation() {
        return this.isBorderAnimation;
    }

    public void setBorderAnimation(boolean isBorderAnimation) {
        this.isBorderAnimation = isBorderAnimation;
    }

    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    AutoScrollViewPager.this.scrollOnce();
                    AutoScrollViewPager.this.sendScrollMessage(AutoScrollViewPager.this.interval);
                }
                case 1: {
                    AutoScrollViewPager.this.scrollPre(msg.getData().getInt("num"));
                    break;
                }
                case 2: {
                    AutoScrollViewPager.this.scrollNext();
                    break;
                }
            }
        }
    }
}

