/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.utils;

import android.app.ProgressDialog;
import android.content.Context;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.art.uilibrary.R;
import com.art.uilibrary.widget.dialog.AlertDialog;
import com.art.uilibrary.widget.dialog.LoadingDialog;

public class UiUtils {
    private static ProgressDialog mProgressDialog;
    private static LoadingDialog mLoadingDialog;

    public static void showLoading(Context context) {
        String title = context.getResources().getString(R.string.str_prompt);
        String msg = context.getResources().getString(R.string.str_loading);
        UiUtils.showLoading(context, title, msg);
    }

    public static void showLoading(Context context, CharSequence title, CharSequence message) {
        mLoadingDialog = new LoadingDialog(context).builder();
        mLoadingDialog.show();
    }

    public static void dismissLoading() {
        if (mLoadingDialog != null) {
            mLoadingDialog.dismiss();
            mLoadingDialog = null;
        }
    }

    public static void showConfirmDialog(Context context, final Object resTarget, final IOnConfirmDialogClickListener listener, Object negMsg, Object posMsg, boolean negInVisible, boolean posInVisible) {
        AlertDialog mAlertDialog = new AlertDialog(context).builder();
        mAlertDialog.setMsg(resTarget);
        mAlertDialog.setNegativeButton(negMsg, new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
        mAlertDialog.setPositiveButton(posMsg, new View.OnClickListener(){

            public void onClick(View view) {
                if (listener != null) {
                    listener.onDialogConfirm(resTarget);
                }
            }
        });
        if (negInVisible) {
            mAlertDialog.setNegInVisible();
        }
        if (posInVisible) {
            mAlertDialog.setPosInVisible();
        }
        mAlertDialog.show();
    }

    public static void showConfirmDialog(Context context, Object titelResTarget, final Object resTarget, final IOnConfirmDialogClickListener listener, Object negMsg, Object posMsg, boolean negInVisible, boolean posInVisible) {
        AlertDialog mAlertDialog = new AlertDialog(context).builder();
        mAlertDialog.setTitle(titelResTarget);
        mAlertDialog.setMsg(resTarget);
        mAlertDialog.setNegativeButton(negMsg, new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
        mAlertDialog.setPositiveButton(posMsg, new View.OnClickListener(){

            public void onClick(View view) {
                if (listener != null) {
                    listener.onDialogConfirm(resTarget);
                }
            }
        });
        if (negInVisible) {
            mAlertDialog.setNegInVisible();
        }
        if (posInVisible) {
            mAlertDialog.setPosInVisible();
        }
        mAlertDialog.show();
    }

    public static void showConfirmDialog(Context context, Object resTarget, IOnConfirmDialogClickListener listener, Object negMsg, Object posMsg) {
        UiUtils.showConfirmDialog(context, resTarget, listener, negMsg, posMsg, false, false);
    }

    public static void showConfirmDialog(Context context, Object resTarget, Object negMsg, boolean negInVisible, boolean posInVisible) {
        UiUtils.showConfirmDialog(context, resTarget, null, negMsg, "", negInVisible, posInVisible);
    }

    public static void setRecycleStyle(Context context, RecyclerView recyclerView, RecycleStyle recycleStyle, int spanCount) {
        if (recycleStyle == RecycleStyle.RECYCLE_LV) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        } else if (recycleStyle == RecycleStyle.RECYCLE_GV) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(context, spanCount));
        } else if (recycleStyle == RecycleStyle.RECYCLE_WF) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(spanCount, 1));
        }
    }

    public static enum RecycleStyle {
        RECYCLE_LV,
        RECYCLE_GV,
        RECYCLE_WF;

    }

    public static interface IOnConfirmDialogClickListener {
        public void onDialogConfirm(Object var1);
    }
}

