/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Date;

public final class FileUtils {
    public static String SDPATH = Environment.getExternalStorageDirectory() + "/formats/";
    private static final File storageParentPath = Environment.getExternalStorageDirectory();
    private static final File phoneParentPath = Environment.getRootDirectory();
    private static String storagePath = "";
    private static final String DST_FOLDER_NAME = "Image";
    private static final String IMAGE_NAME = "image";
    public static final String CAMERA_IMAGES_FOLDER_NAME = "IMAGES";
    public static final String PHOTO_IMAGE_NAME = "photo.jpg";

    public static String getSysPath() {
        if (storagePath.equals("")) {
            storagePath = "mounted".equals(Environment.getExternalStorageState()) ? storageParentPath.getAbsolutePath() : phoneParentPath.getAbsolutePath();
        }
        return storagePath;
    }

    public static String getCameraImagesPath() {
        String path = FileUtils.getSysPath() + "/" + CAMERA_IMAGES_FOLDER_NAME;
        File destDir = new File(path);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return path;
    }

    public static String getPhotoPath() {
        String path = FileUtils.getSysPath() + "/" + PHOTO_IMAGE_NAME;
        File destDir = new File(path);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return path;
    }

    private static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFile = file.listFiles();
            if (childFile == null || childFile.length == 0) {
                file.delete();
                return;
            }
            for (File f : childFile) {
                FileUtils.deleteFile(f);
                Log.d((String)"\u5220\u9664", (String)"\u6b63\u5728\u5220\u9664");
            }
            file.delete();
        }
    }

    public static void deleteCameraImage() {
        File destDir = new File(FileUtils.getPhotoPath());
        FileUtils.deleteFile(destDir);
    }

    public static String saveBitmap(Bitmap b) {
        String path = FileUtils.getSysPath();
        File f = new File(path + "/" + DST_FOLDER_NAME);
        if (!f.exists()) {
            f.mkdir();
        }
        String jpegName = path + "/" + DST_FOLDER_NAME + "/" + IMAGE_NAME + new Date().getTime() + ".jpg";
        try {
            FileOutputStream fout = new FileOutputStream(jpegName);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
            return jpegName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean checkSDcard() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static void saveFileCache(byte[] fileData, String folderPath, String fileName) {
        File folder = new File(folderPath);
        folder.mkdirs();
        File file = new File(folderPath, fileName);
        ByteArrayInputStream is = new ByteArrayInputStream(fileData);
        FileOutputStream os = null;
        if (!file.exists()) {
            try {
                file.createNewFile();
                os = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int len = 0;
                while (-1 != (len = is.read(buffer))) {
                    ((OutputStream)os).write(buffer, 0, len);
                }
                os.flush();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(FileUtils.class.getClass().getName(), e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeIO(is, os);
                    throw throwable;
                }
            }
            FileUtils.closeIO(is, os);
        }
    }

    public static File getSaveFile(String folderPath, String fileNmae) {
        File file = new File(FileUtils.getSavePath(folderPath) + File.separator + fileNmae);
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static String getSavePath(String folderName) {
        return FileUtils.getSaveFolder(folderName).getAbsolutePath();
    }

    public static File getSaveFolder(String folderName) {
        File file = new File(FileUtils.getSDCardPath() + File.separator + folderName + File.separator);
        file.mkdirs();
        return file;
    }

    public static String getSDCardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] input2byte(InputStream inStream) {
        if (inStream == null) {
            return null;
        }
        byte[] in2b = null;
        BufferedInputStream in = new BufferedInputStream(inStream);
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        int rc = 0;
        try {
            while ((rc = in.read()) != -1) {
                swapStream.write(rc);
            }
            in2b = swapStream.toByteArray();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(inStream, in, swapStream);
                throw throwable;
            }
            FileUtils.closeIO(inStream, in, swapStream);
        }
        FileUtils.closeIO(inStream, in, swapStream);
        return in2b;
    }

    public static void copyFile(File from, File to) {
        if (null == from || !from.exists()) {
            return;
        }
        if (null == to) {
            return;
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(from);
            if (!to.exists()) {
                to.createNewFile();
            }
            os = new FileOutputStream(to);
            FileUtils.copyFileFast(is, os);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(FileUtils.class.getClass().getName(), e);
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(is, os);
                throw throwable;
            }
        }
        FileUtils.closeIO(is, os);
    }

    public static void copyFileFast(FileInputStream is, FileOutputStream os) throws IOException {
        FileChannel in = is.getChannel();
        FileChannel out = os.getChannel();
        in.transferTo(0L, in.size(), out);
    }

    public static void closeIO(Closeable ... closeables) {
        if (null == closeables || closeables.length <= 0) {
            return;
        }
        for (Closeable cb : closeables) {
            try {
                if (null == cb) continue;
                cb.close();
            }
            catch (IOException e) {
                throw new RuntimeException(FileUtils.class.getClass().getName(), e);
            }
        }
    }

    public static Bitmap compressBitmap(Bitmap image, int maxkb) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        Log.i((String)"test", (String)("\u539f\u59cb\u5927\u5c0f =" + baos.toByteArray().length));
        while (baos.toByteArray().length / 1024 > maxkb) {
            baos.reset();
            image.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)baos);
        }
        Log.i((String)"test", (String)("\u538b\u7f29\u540e\u5927\u5c0f =" + baos.toByteArray().length / 1024 + "K"));
        ByteArrayInputStream isBm = new ByteArrayInputStream(baos.toByteArray());
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)isBm, null, null);
        try {
            baos.close();
            isBm.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    public static int getBitmapSize(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean bitmapToFile(Bitmap bitmap, String filePath) {
        boolean isSuccess = false;
        if (bitmap == null) {
            return isSuccess;
        }
        File file = new File(filePath.substring(0, filePath.lastIndexOf(File.separator)));
        if (!file.exists()) {
            file.mkdirs();
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(filePath), 8192);
            isSuccess = bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtils.closeIO(out);
                throw throwable;
            }
            FileUtils.closeIO(out);
        }
        FileUtils.closeIO(out);
        return isSuccess;
    }

    public static String readFile(String filePath) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
        }
        catch (Exception e) {
            throw new RuntimeException(FileUtils.class.getName() + "readFile---->" + filePath + " not found");
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    Log.d((String)"FileUtils", (String)e.getMessage());
                }
            }
        }
        return FileUtils.inputStream2String(is);
    }

    public static String readFileFromAssets(Context context, String name) {
        InputStream is = null;
        try {
            is = context.getResources().getAssets().open(name);
        }
        catch (Exception e) {
            throw new RuntimeException(FileUtils.class.getName() + ".readFileFromAssets---->" + name + " not found");
        }
        return FileUtils.inputStream2String(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStream2String(InputStream is) {
        if (null == is) {
            return null;
        }
        StringBuilder resultSb = null;
        try {
            String len;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            resultSb = new StringBuilder();
            while (null != (len = br.readLine())) {
                resultSb.append(len);
            }
        }
        catch (Exception exception) {
            FileUtils.closeIO(is);
        }
        catch (Throwable throwable) {
            FileUtils.closeIO(is);
            throw throwable;
        }
        FileUtils.closeIO(is);
        return null == resultSb ? null : resultSb.toString();
    }

    public static void deleteDir() {
        File dir = new File(SDPATH);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            FileUtils.deleteDir();
        }
        dir.delete();
    }

    public static void delFile(String fileName) {
        File file = new File(SDPATH + fileName);
        if (file.isFile()) {
            file.delete();
        }
        file.exists();
    }
}

