/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.GeolocationPermissions;
import android.webkit.JsResult;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.art.uilibrary.R;

public class HTML5WebView
extends WebView {
    private static final String LOGTAG = "HTML5WebView";
    static final FrameLayout.LayoutParams COVER_SCREEN_PARAMS = new FrameLayout.LayoutParams(-1, -1);
    private Context mContext;
    private MyWebChromeClient mWebChromeClient;
    private View mCustomView;
    private FrameLayout mCustomViewContainer;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private FrameLayout mBrowserFrameLayout;
    private boolean isCanBack = true;
    private IOnPickPhotoListener listener;

    public HTML5WebView(Context context) {
        super(context);
        this.init(context);
    }

    public HTML5WebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public HTML5WebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        Activity a = (Activity)this.mContext;
        this.mBrowserFrameLayout = (FrameLayout)LayoutInflater.from((Context)a).inflate(R.layout.h5_screen, null);
        FrameLayout contentView = (FrameLayout)this.mBrowserFrameLayout.findViewById(R.id.main_content);
        this.mCustomViewContainer = (FrameLayout)this.mBrowserFrameLayout.findViewById(R.id.fullscreen_custom_content);
        this.mWebChromeClient = new MyWebChromeClient();
        this.setWebChromeClient(this.mWebChromeClient);
        this.setWebViewClient(new MyWebViewClient());
        WebSettings s = this.getSettings();
        s.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        s.setUseWideViewPort(false);
        s.setLoadWithOverviewMode(true);
        s.setSaveFormData(true);
        s.setJavaScriptEnabled(true);
        s.setGeolocationEnabled(true);
        s.setGeolocationDatabasePath(context.getApplicationContext().getCacheDir().getAbsolutePath() + "/geo/");
        s.setDomStorageEnabled(true);
        s.setDatabaseEnabled(true);
        s.setDatabasePath(context.getApplicationContext().getCacheDir().getAbsolutePath() + "/db/");
        s.setAppCacheEnabled(true);
        s.setAppCachePath(context.getApplicationContext().getCacheDir().getAbsolutePath());
        s.setCacheMode(-1);
        s.setSupportZoom(false);
        s.setBuiltInZoomControls(false);
        s.setDefaultTextEncodingName("utf-8");
        contentView.addView((View)this);
    }

    public FrameLayout getLayout() {
        return this.mBrowserFrameLayout;
    }

    public boolean inCustomView() {
        return this.mCustomView != null;
    }

    public void hideCustomView() {
        this.mWebChromeClient.onHideCustomView();
    }

    public void disableCanBack() {
        this.isCanBack = false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isCanBack && this.mCustomView == null && this.canGoBack()) {
            this.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public WebChromeClient getChromeClient() {
        return this.mWebChromeClient;
    }

    public void setOnPickPhotoListener(IOnPickPhotoListener listener) {
        this.listener = listener;
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Log.i((String)HTML5WebView.LOGTAG, (String)("shouldOverrideUrlLoading: " + url));
            view.loadUrl(url);
            return true;
        }
    }

    private class MyWebChromeClient
    extends WebChromeClient {
        private Bitmap mDefaultVideoPoster;
        private View mVideoProgressView;

        private MyWebChromeClient() {
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            HTML5WebView.this.listener.showConfirmDialog(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
            HTML5WebView.this.listener.showConfirmDialog(uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
            HTML5WebView.this.listener.showConfirmDialog(uploadMsg);
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> uploadMsg, WebChromeClient.FileChooserParams fileChooserParams) {
            HTML5WebView.this.listener.getMultiImage(uploadMsg);
            return true;
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            HTML5WebView.this.setVisibility(8);
            if (HTML5WebView.this.mCustomView != null) {
                callback.onCustomViewHidden();
                return;
            }
            HTML5WebView.this.mCustomViewContainer.addView(view);
            HTML5WebView.this.mCustomView = view;
            HTML5WebView.this.mCustomViewCallback = callback;
            HTML5WebView.this.mCustomViewContainer.setVisibility(0);
        }

        public void onHideCustomView() {
            if (HTML5WebView.this.mCustomView == null) {
                return;
            }
            HTML5WebView.this.mCustomView.setVisibility(8);
            HTML5WebView.this.mCustomViewContainer.removeView(HTML5WebView.this.mCustomView);
            HTML5WebView.this.mCustomView = null;
            HTML5WebView.this.mCustomViewContainer.setVisibility(8);
            HTML5WebView.this.mCustomViewCallback.onCustomViewHidden();
            HTML5WebView.this.setVisibility(0);
        }

        public Bitmap getDefaultVideoPoster() {
            if (this.mDefaultVideoPoster == null) {
                this.mDefaultVideoPoster = BitmapFactory.decodeResource((Resources)HTML5WebView.this.getResources(), (int)R.drawable.anim_progress_round);
            }
            return this.mDefaultVideoPoster;
        }

        public View getVideoLoadingProgressView() {
            if (this.mVideoProgressView == null) {
                LayoutInflater inflater = LayoutInflater.from((Context)HTML5WebView.this.mContext);
                this.mVideoProgressView = inflater.inflate(R.layout.h5_loading, null);
            }
            return this.mVideoProgressView;
        }

        public void onReceivedTitle(WebView view, String title) {
            ((Activity)HTML5WebView.this.mContext).setTitle((CharSequence)title);
        }

        public void onProgressChanged(WebView view, int newProgress) {
            ((Activity)HTML5WebView.this.mContext).getWindow().setFeatureInt(2, newProgress * 100);
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            callback.invoke(origin, true, false);
        }

        public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
            AlertDialog.Builder builder = new AlertDialog.Builder(HTML5WebView.this.mContext);
            builder.setTitle((CharSequence)"Alert");
            builder.setMessage((CharSequence)message);
            builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.confirm();
                }
            });
            builder.setCancelable(false);
            builder.create();
            builder.show();
            return true;
        }

        public boolean onJsConfirm(WebView view, String url, String message, final JsResult result) {
            AlertDialog.Builder builder = new AlertDialog.Builder(HTML5WebView.this.mContext);
            builder.setTitle((CharSequence)"confirm");
            builder.setMessage((CharSequence)message);
            builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.confirm();
                }
            });
            builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    result.cancel();
                }
            });
            builder.setCancelable(false);
            builder.create();
            builder.show();
            return true;
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
            quotaUpdater.updateQuota(estimatedSize * 2L);
        }
    }

    public static interface IOnPickPhotoListener {
        public void showConfirmDialog(ValueCallback<Uri> var1);

        public void getMultiImage(ValueCallback<Uri[]> var1);
    }
}

