/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.art.uilibrary.R;
import com.art.uilibrary.utils.UiScreenUtils;

public class TopicViewGroup
extends ViewGroup {
    protected float horizontalSpace;
    protected float vertivalSpace;
    private int showRaw = 0;

    public TopicViewGroup(Context context) {
        super(context, null, 0);
        this.horizontalSpace = UiScreenUtils.dp2Px(context, 10.0f);
        this.vertivalSpace = UiScreenUtils.dp2Px(context, 10.0f);
    }

    public TopicViewGroup(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TopicViewGroup);
        int defHorizontalSpace = typedArray.getInt(R.styleable.TopicViewGroup_horizontalSpace, 10);
        int defVertivalSpace = typedArray.getInt(R.styleable.TopicViewGroup_vertivalSpace, 10);
        typedArray.recycle();
        this.horizontalSpace = UiScreenUtils.dp2Px(context, defHorizontalSpace);
        this.vertivalSpace = UiScreenUtils.dp2Px(context, defVertivalSpace);
    }

    public void setShowRaw(int showRaw) {
        this.showRaw = showRaw;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = 0;
        int height = 0;
        int rawWidth = 0;
        int rawHeight = 0;
        int rowIndex = 0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) {
                if (i != count - 1) continue;
                height += rawHeight;
                width = Math.max(width, rawWidth);
                continue;
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin;
            int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
            float f = rawWidth + childWidth;
            float f2 = rowIndex > 0 ? this.horizontalSpace : 0.0f;
            if (f + f2 > (float)(widthSpecSize - this.getPaddingLeft() - this.getPaddingRight())) {
                width = Math.max(width, rawWidth);
                rawWidth = childWidth;
                height = (int)((float)height + ((float)rawHeight + this.vertivalSpace));
                rawHeight = childHeight;
                rowIndex = 0;
            } else {
                rawWidth += childWidth;
                if (rowIndex > 0) {
                    rawWidth = (int)((float)rawWidth + this.horizontalSpace);
                }
                rawHeight = Math.max(rawHeight, childHeight);
            }
            if (i == count - 1) {
                width = Math.max(rawWidth, width);
                height += rawHeight;
                if (this.showRaw == 1) {
                    height = rawHeight;
                }
            }
            ++rowIndex;
        }
        this.setMeasuredDimension(widthSpecMode == 0x40000000 ? widthSpecSize : width + this.getPaddingLeft() + this.getPaddingRight(), heightSpecMode == 0x40000000 ? heightSpecSize : height + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int viewWidth = r - l;
        int leftOffset = this.getPaddingLeft();
        int topOffset = this.getPaddingTop();
        int rowMaxHeight = 0;
        int rowIndex = 0;
        int count = this.getChildCount();
        for (int w = 0; w < count; ++w) {
            View childView = this.getChildAt(w);
            if (childView.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)childView.getLayoutParams();
            int occupyWidth = lp.leftMargin + childView.getMeasuredWidth() + lp.rightMargin;
            if (leftOffset + occupyWidth + this.getPaddingRight() > viewWidth) {
                leftOffset = this.getPaddingLeft();
                topOffset = (int)((float)topOffset + ((float)rowMaxHeight + this.vertivalSpace));
                rowMaxHeight = 0;
                rowIndex = 0;
            }
            int left = leftOffset + lp.leftMargin;
            int top = topOffset + lp.topMargin;
            int right = leftOffset + lp.leftMargin + childView.getMeasuredWidth();
            int bottom = topOffset + lp.topMargin + childView.getMeasuredHeight();
            childView.layout(left, top, right, bottom);
            leftOffset += occupyWidth;
            int occupyHeight = lp.topMargin + childView.getMeasuredHeight() + lp.bottomMargin;
            if (rowIndex != count - 1) {
                leftOffset = (int)((float)leftOffset + this.horizontalSpace);
            }
            rowMaxHeight = Math.max(rowMaxHeight, occupyHeight);
            ++rowIndex;
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }
}

