/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;

public class AutoScrollView
extends ScrollView {
    private OnBorderListener onBorderListener;
    private View contentView;
    private float xDistance;
    private float yDistance;
    private float xLast;
    private float yLast;

    public AutoScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setFillViewport(true);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        try {
            super.onRestoreInstanceState(state);
        }
        catch (Exception exception) {
            // empty catch block
        }
        state = null;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.yDistance = 0.0f;
                this.xDistance = 0.0f;
                this.xLast = ev.getX();
                this.yLast = ev.getY();
                break;
            }
            case 2: {
                float curX = ev.getX();
                float curY = ev.getY();
                this.xDistance += Math.abs(curX - this.xLast);
                this.yDistance += Math.abs(curY - this.yLast);
                this.xLast = curX;
                this.yLast = curY;
                if (!(this.xDistance > this.yDistance)) break;
                return false;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    protected void onScrollChanged(int x, int y, int oldx, int oldy) {
        super.onScrollChanged(x, y, oldx, oldy);
        this.doOnBorderListener();
    }

    public void setOnBorderListener(OnBorderListener onBorderListener) {
        this.onBorderListener = onBorderListener;
        if (onBorderListener == null) {
            return;
        }
        if (this.contentView == null) {
            this.contentView = this.getChildAt(0);
        }
    }

    private void doOnBorderListener() {
        if (this.contentView != null && this.contentView.getMeasuredHeight() <= this.getScrollY() + this.getHeight()) {
            if (this.onBorderListener != null) {
                this.onBorderListener.onBottom();
            }
        } else if (this.getScrollY() == 0 && this.onBorderListener != null) {
            this.onBorderListener.onTop();
        }
    }

    public static interface OnBorderListener {
        public void onBottom();

        public void onTop();
    }
}

