/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.WindowManager;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.Scroller;

public class AdapterHorizontalScrollView
extends HorizontalScrollView {
    private LinearLayout mContainer;
    private int mScreenWidth;
    private int mCurrentIndex;
    private int mChildCount;
    private Scroller mScroller;
    private int mLastViewX;
    float mLastX;
    boolean mScrollLeft;

    public AdapterHorizontalScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        this.mScreenWidth = outMetrics.widthPixels;
        this.mScroller = new Scroller(context);
        this.mLastViewX = this.mScreenWidth;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mContainer = (LinearLayout)this.getChildAt(0);
        this.mChildCount = this.mContainer.getChildCount();
        Log.d((String)"ScrollView", (String)("getChildCount:" + this.mChildCount));
    }

    public boolean onTouchEvent(MotionEvent ev) {
        float rawX = ev.getRawX();
        switch (ev.getAction()) {
            case 0: {
                Log.d((String)"ScrollView", (String)("ACTION_DOWN X:" + ev.getX() + "\t ScrollX: \t" + this.getScrollX()));
                break;
            }
            case 2: {
                Log.d((String)"ScrollView", (String)("ACTION_MOVE X:" + ev.getX() + "\t ScrollX: \t" + this.getScrollX()));
                this.mScrollLeft = rawX - this.mLastX <= 0.0f;
                this.mLastX = rawX;
                break;
            }
            case 1: 
            case 3: {
                Log.d((String)"ScrollView", (String)("ACTION_UP X:" + ev.getX() + "\t ScrollX: \t" + this.getScrollX()));
                if (!(this.mScrollLeft ? this.loadNext() : this.loadPre())) break;
                return true;
            }
        }
        return super.onTouchEvent(ev);
    }

    private boolean loadNext() {
        if (++this.mCurrentIndex > this.mChildCount) {
            --this.mCurrentIndex;
            return false;
        }
        int scrollToX = this.mLastViewX + this.mScreenWidth;
        this.mScroller.startScroll(this.getScrollX(), 0, scrollToX, 0, 300);
        this.mLastViewX = scrollToX;
        Log.d((String)"ScrollView", (String)("loadNext" + scrollToX));
        return true;
    }

    private boolean loadPre() {
        if (--this.mCurrentIndex < 0) {
            this.mCurrentIndex = 0;
            return false;
        }
        int scrollToX = this.mLastViewX - this.mScreenWidth;
        this.mScroller.startScroll(this.getScrollX(), 0, scrollToX, 0, 300);
        this.mLastViewX = scrollToX;
        Log.d((String)"ScrollView", (String)("loadPre" + scrollToX));
        return true;
    }
}

