/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.viewpager;

import android.util.SparseArray;
import android.view.View;

class RecycleBin {
    private final View[] activeViews = new View[0];
    private final int[] activeViewTypes = new int[0];
    private SparseArray<View>[] scrapViews;
    private int viewTypeCount;
    private SparseArray<View> currentScrapViews;

    RecycleBin() {
    }

    private static View retrieveFromScrap(SparseArray<View> scrapViews, int position) {
        int size = scrapViews.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                int fromPosition = scrapViews.keyAt(i);
                View view = (View)scrapViews.get(fromPosition);
                if (fromPosition != position) continue;
                scrapViews.remove(fromPosition);
                return view;
            }
            int index = size - 1;
            View r = (View)scrapViews.valueAt(index);
            scrapViews.remove(scrapViews.keyAt(index));
            return r;
        }
        return null;
    }

    public void setViewTypeCount(int viewTypeCount) {
        if (viewTypeCount < 1) {
            throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
        }
        SparseArray[] scrapViews = new SparseArray[viewTypeCount];
        for (int i = 0; i < viewTypeCount; ++i) {
            scrapViews[i] = new SparseArray();
        }
        this.viewTypeCount = viewTypeCount;
        this.currentScrapViews = scrapViews[0];
        this.scrapViews = scrapViews;
    }

    private boolean shouldRecycleViewType(int viewType) {
        return viewType >= 0;
    }

    View getScrapView(int position, int viewType) {
        if (this.viewTypeCount == 1) {
            return RecycleBin.retrieveFromScrap(this.currentScrapViews, position);
        }
        if (viewType >= 0 && viewType < this.scrapViews.length) {
            return RecycleBin.retrieveFromScrap(this.scrapViews[viewType], position);
        }
        return null;
    }

    void addScrapView(View scrap, int position, int viewType) {
        if (this.viewTypeCount == 1) {
            this.currentScrapViews.put(position, (Object)scrap);
        } else {
            this.scrapViews[viewType].put(position, (Object)scrap);
        }
    }

    void scrapActiveViews() {
        View[] activeViews = this.activeViews;
        int[] activeViewTypes = this.activeViewTypes;
        boolean multipleScraps = this.viewTypeCount > 1;
        SparseArray<View> scrapViews = this.currentScrapViews;
        int count = activeViews.length;
        for (int i = count - 1; i >= 0; --i) {
            View victim = activeViews[i];
            if (victim == null) continue;
            int whichScrap = activeViewTypes[i];
            activeViews[i] = null;
            activeViewTypes[i] = -1;
            if (!this.shouldRecycleViewType(whichScrap)) continue;
            if (multipleScraps) {
                scrapViews = this.scrapViews[whichScrap];
            }
            scrapViews.put(i, (Object)victim);
        }
        this.pruneScrapViews();
    }

    private void pruneScrapViews() {
        int maxViews = this.activeViews.length;
        int viewTypeCount = this.viewTypeCount;
        SparseArray<View>[] scrapViews = this.scrapViews;
        for (int i = 0; i < viewTypeCount; ++i) {
            SparseArray<View> scrapPile = scrapViews[i];
            int size = scrapPile.size();
            int extras = size - maxViews;
            --size;
            for (int j = 0; j < extras; ++j) {
                scrapPile.remove(scrapPile.keyAt(size--));
            }
        }
    }
}

