/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import java.io.FileInputStream;
import java.io.IOException;

public class UiImageUtils {
    public static final String TAG = "ImageUtils";
    private static final float BITMAP_SCALE = 0.4f;
    private static final float BLUR_RADIUS = 25.0f;
    public static final String TYPE_JPG = "jpg";
    public static final String TYPE_GIF = "gif";
    public static final String TYPE_PNG = "png";
    public static final String TYPE_BMP = "bmp";
    public static final String TYPE_UNKNOWN = "unknown";

    public static int getBitmapSize(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount() / 1024;
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount() / 1024;
        }
        return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
    }

    public static Bitmap drawable2Bitmap(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)(drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static Bitmap getResize(Bitmap bm, int newWidth, int newHeight) {
        Bitmap fBitmap;
        int width = bm.getWidth();
        int height = bm.getHeight();
        float wScale = newWidth > width ? (float)newWidth / (float)width : (float)width / (float)newWidth;
        float hScale = newHeight > height ? (float)newHeight / (float)height : (float)height / (float)newHeight;
        Matrix matrix = new Matrix();
        if (wScale > hScale) {
            matrix.postScale(wScale, wScale);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            fBitmap = Bitmap.createBitmap((Bitmap)newBitmap, (int)0, (int)((newBitmap.getHeight() - newHeight) / 2), (int)newWidth, (int)newHeight, null, (boolean)false);
            newBitmap.recycle();
        } else if (wScale < hScale) {
            matrix.postScale(hScale, hScale);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            fBitmap = Bitmap.createBitmap((Bitmap)newBitmap, (int)((newBitmap.getWidth() - newWidth) / 2), (int)0, (int)newWidth, (int)newHeight, null, (boolean)false);
            newBitmap.recycle();
        } else {
            Bitmap newBitmap;
            matrix.postScale(wScale, wScale);
            fBitmap = newBitmap = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return fBitmap;
    }

    public static int[] getImageWidthHeight(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }

    public static Bitmap blur(Context context, Bitmap image, float BLUR_RADIUS) {
        int width = Math.round((float)image.getWidth() * 0.4f);
        int height = Math.round((float)image.getHeight() * 0.4f);
        Bitmap inputBitmap = Bitmap.createScaledBitmap((Bitmap)image, (int)width, (int)height, (boolean)false);
        Bitmap outputBitmap = Bitmap.createBitmap((Bitmap)inputBitmap);
        RenderScript rs = RenderScript.create((Context)context);
        ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
        Allocation tmpIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)inputBitmap);
        Allocation tmpOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)outputBitmap);
        blurScript.setRadius(BLUR_RADIUS);
        blurScript.setInput(tmpIn);
        blurScript.forEach(tmpOut);
        tmpOut.copyTo(outputBitmap);
        return outputBitmap;
    }

    public static Bitmap getBitmapBySize(String path, int width, int height) {
        BitmapFactory.Options option = new BitmapFactory.Options();
        option.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)option);
        option.inSampleSize = UiImageUtils.computeSampleSize(option, -1, width * height);
        option.inJustDecodeBounds = false;
        Bitmap bitmap = null;
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)option);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    private static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = UiImageUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPicType(FileInputStream fis) {
        byte[] b = new byte[4];
        try {
            fis.read(b, 0, b.length);
            String type = UiImageUtils.bytesToHexString(b).toUpperCase();
            if (type.contains("FFD8FF")) {
                String string2 = TYPE_JPG;
                return string2;
            }
            if (type.contains("89504E47")) {
                String string3 = TYPE_PNG;
                return string3;
            }
            if (type.contains("47494638")) {
                String string4 = TYPE_GIF;
                return string4;
            }
            if (type.contains("424D")) {
                String string5 = TYPE_BMP;
                return string5;
            }
            String string6 = TYPE_UNKNOWN;
            return string6;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = UiImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }
}

