/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.art.uilibrary.pullrefresh.FooterLoadingLayout;
import com.art.uilibrary.pullrefresh.ILoadingLayout;
import com.art.uilibrary.pullrefresh.LoadingLayout;
import com.art.uilibrary.pullrefresh.PullToRefreshBase;

public class PullToRefreshGridView
extends PullToRefreshBase<GridView>
implements AbsListView.OnScrollListener {
    private GridView mGridView;
    private LoadingLayout mFooterLayout;
    private AbsListView.OnScrollListener mScrollListener;

    public PullToRefreshGridView(Context context) {
        this(context, null);
    }

    public PullToRefreshGridView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullToRefreshGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setPullLoadEnabled(false);
    }

    @Override
    protected GridView createRefreshableView(Context context, AttributeSet attrs) {
        GridView gridView;
        this.mGridView = gridView = new GridView(context);
        gridView.setOnScrollListener((AbsListView.OnScrollListener)this);
        return gridView;
    }

    public void setHasMoreData(boolean hasMoreData) {
        if (this.mFooterLayout != null && !hasMoreData) {
            this.mFooterLayout.setState(ILoadingLayout.State.NO_MORE_DATA);
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mScrollListener = l;
    }

    @Override
    protected boolean isReadyForPullUp() {
        return this.isLastItemVisible();
    }

    @Override
    protected boolean isReadyForPullDown() {
        return this.isFirstItemVisible();
    }

    @Override
    protected void startLoading() {
        super.startLoading();
        System.out.println("qwsljd--------------------------");
        if (this.mFooterLayout != null) {
            this.mFooterLayout.setState(ILoadingLayout.State.REFRESHING);
        }
    }

    @Override
    public void onPullUpRefreshComplete() {
        super.onPullUpRefreshComplete();
        if (this.mFooterLayout != null) {
            this.mFooterLayout.setState(ILoadingLayout.State.RESET);
        }
    }

    @Override
    public void setScrollLoadEnabled(boolean scrollLoadEnabled) {
        super.setScrollLoadEnabled(scrollLoadEnabled);
        if (scrollLoadEnabled) {
            if (this.mFooterLayout == null) {
                this.mFooterLayout = new FooterLoadingLayout(this.getContext());
            }
            this.mFooterLayout.show(true);
        } else if (this.mFooterLayout != null) {
            // empty if block
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.isScrollLoadEnabled() && this.hasMoreData() && (scrollState == 0 || scrollState == 2) && this.isReadyForPullUp()) {
            this.startLoading();
        }
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    private boolean hasMoreData() {
        return this.mFooterLayout == null || this.mFooterLayout.getState() != ILoadingLayout.State.NO_MORE_DATA;
    }

    private boolean isFirstItemVisible() {
        ListAdapter adapter = this.mGridView.getAdapter();
        if (adapter == null || adapter.isEmpty()) {
            return true;
        }
        int mostTop = this.mGridView.getChildCount() > 0 ? this.mGridView.getChildAt(0).getTop() : 0;
        return mostTop >= 0;
    }

    private boolean isLastItemVisible() {
        int childCount;
        int childIndex;
        int index;
        View lastVisibleChild;
        ListAdapter adapter = this.mGridView.getAdapter();
        if (adapter == null || adapter.isEmpty()) {
            return true;
        }
        int lastItemPosition = adapter.getCount() - 1;
        int lastVisiblePosition = this.mGridView.getLastVisiblePosition();
        if (lastVisiblePosition >= lastItemPosition - 1 && (lastVisibleChild = this.mGridView.getChildAt(index = Math.min(childIndex = lastVisiblePosition - this.mGridView.getFirstVisiblePosition(), (childCount = this.mGridView.getChildCount()) - 1))) != null) {
            return lastVisibleChild.getBottom() <= this.mGridView.getBottom();
        }
        return false;
    }
}

