/*
 * Decompiled with CFR 0.152.
 */
package com.art.uilibrary.pullrefresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.art.uilibrary.R;
import com.art.uilibrary.pullrefresh.ILoadingLayout;
import com.art.uilibrary.pullrefresh.LoadingLayout;

public class FooterLoadingLayout
extends LoadingLayout {
    private ProgressBar mProgressBar;
    private TextView mHintView;

    public FooterLoadingLayout(Context context) {
        super(context);
        this.init(context);
    }

    public FooterLoadingLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.pull_to_load_footer_progressbar);
        this.mHintView = (TextView)this.findViewById(R.id.pull_to_load_footer_hint_textview);
        this.setState(ILoadingLayout.State.RESET);
    }

    @Override
    protected View createLoadingView(Context context, AttributeSet attrs) {
        return LayoutInflater.from((Context)context).inflate(R.layout.ptr_pull_to_load_footer, null);
    }

    @Override
    public void setLastUpdatedLabel(CharSequence label) {
    }

    @Override
    public int getContentSize() {
        View view = this.findViewById(R.id.pull_to_load_footer_content);
        if (view != null) {
            return view.getHeight();
        }
        return (int)(this.getResources().getDisplayMetrics().density * 70.0f);
    }

    @Override
    protected void onStateChanged(ILoadingLayout.State curState, ILoadingLayout.State oldState) {
        this.mProgressBar.setVisibility(8);
        this.mHintView.setVisibility(4);
        super.onStateChanged(curState, oldState);
    }

    @Override
    protected void onReset() {
        this.mHintView.setText(R.string.pull_to_refresh_header_hint_loading);
    }

    @Override
    protected void onPullToRefresh() {
        this.mHintView.setVisibility(0);
        this.mHintView.setText(R.string.pull_to_refresh_header_hint_normal2);
    }

    @Override
    protected void onReleaseToRefresh() {
        this.mHintView.setVisibility(0);
        this.mHintView.setText(R.string.pull_to_refresh_header_hint_ready);
    }

    @Override
    public void onRefreshing() {
        this.mProgressBar.setVisibility(0);
        this.mHintView.setVisibility(0);
        this.mHintView.setText(R.string.pull_to_refresh_header_hint_loading);
    }

    @Override
    protected void onNoMoreData() {
        this.mHintView.setVisibility(0);
        this.mHintView.setText(R.string.pushmsg_center_no_more_msg);
    }
}

